/*
 * read_data.c
 *
 *  Created on: Dec 26, 2013
 *      Author: shengz
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "global_variables.h"


void readFAM(char *name) {

	int fam = 0, famold = 1;
	int indnumber = 0, ind = 0, aff;

	if ((famfile = fopen(name, "r")) == NULL) {
		printf("Can't open %s\n", name);
		exit(1);
	}

	famdata[1].N = 0;
	while (fscanf(famfile, "%d %d %d%*[^\n]", &fam, &ind, &aff) == 3) {

		if (fam != famold && fam != (famold + 1)) {
			printf(
					"Problems with family %d.\n Family should have following Id numbers from 1 to N\n",
					fam);
			exit(1);
		}
		if (fam == famold)
			famdata[fam].N++;
		else
			famdata[fam].N = 1;
		indnumber++;
		famold = fam;
	}

	N = indnumber;
	F = fam;
	if (F > MAXFAM) {
		printf(
				"Number of families exceeds the maximum number of families allowed\n. You should try to change the value of MAXFAM in the CC-QLStest.c file and recompile.\n\n");
		exit(1);
	}
	rewind(famfile);

}

void readcov1() {
	//declare temporary variables used in the function
	double cov = 0;
	int n = 0;
	//the length in characters for a covariate value (double) is no more than 10
	char line[10 * (MAXCOV + 1)];
	int length = 10 * (MAXCOV + 1);

	Ncov = 0;
	fscanf(famfile, "%*d %*d %*d");
	fgets(line, length, famfile);
	n = sscanf(line, "%f %[^\n]", &cov, line);
	if (n < 1) {
		printf(
				"No covariates found. Please check first line in covariate data file\n");
	} else {
		Ncov++;

		while (n == 2) {
			n = sscanf(line, "%f %[^\n]", &cov, line);
			if (n >= 1) {
				Ncov++;
			}
		}
	}
	if (Ncov > MAXCOV) {
		printf(
				"Number of covariates exceeds the maximum number of covariates allowed.\nYou should try to change the value of MAXCOV in the source file and recompile.\n\n");
		exit(1);
	}
	rewind(famfile);
}

void init_famdata() {
	int i,j,k;
	for (i = 0; i <= F; i++) {

		famdata[i].Pheno = 0;
		famdata[i].Unknown = 0;
		famdata[i].INCORRECTPheno = 0;
		famdata[i].descri = (int*) malloc(((famdata[i].N) + 1) * sizeof(int));
		if (!famdata[i].descri) {
			printf("Error in memory allocation 5\n");
			exit(1);
		}

		famdata[i].AVEC = (double **) malloc((size_t) (((famdata[i].N) + 1)
				* sizeof(double*)));
		for (j = 0; j <= famdata[i].N; j++) {
			famdata[i].AVEC[j] = (double *) malloc((size_t) ((4)
					* sizeof(double)));
		}

		famdata[i].AFFEC = (int **) malloc((size_t) (((famdata[i].N) + 1)
				* sizeof(int*)));
		for (j = 0; j <= famdata[i].N; j++) {
			famdata[i].AFFEC[j] = (int *) malloc((size_t) ((3) * sizeof(int)));
		}

		/*    famdata[i].SEX=(int *)malloc((size_t)(((famdata[i].N)+1)*sizeof(int)));
		 */

		famdata[i].STUDYID = (int *) malloc((size_t) (((famdata[i].N) + 1)
				* sizeof(int)));

		famdata[i].CorrectedAFFEC = (double **) malloc(
				(size_t) (((famdata[i].N) + 1) * sizeof(double*)));
		for (j = 0; j <= famdata[i].N; j++) {
			famdata[i].CorrectedAFFEC[j] = (double *) malloc((size_t) ((4)
					* sizeof(double)));
		}
		for (j = 0; j <= famdata[i].N; j++) {
			for (k = 0; k <= 3; k++) {
				famdata[i].CorrectedAFFEC[j][k] = 0;
			}
		}
	}

	if ((errfile = fopen("CERAMICtest.err", "w")) == NULL) {
		printf("Can't open CERAMICtest.err .\n");
		exit(1);
	}

}


void readdataFAM(struct FAM *famdata, FILE *errfile) {

	int fam = 0, famold = 1;
	int status = 0, indnumber = 0, ind = 0;
	int mycount = 0;

	while ((fscanf(famfile, "%d %d %d%*[^\n]", &fam, &ind, &status)) == 3) {
		if (fam != famold && fam != (famold + 1)) {
			printf(
					"Problems with family %d.\n Family should have following Id numbers from 1 to N\n ",
					fam);
			exit(1);
		}

		if (fam != famold) {
			indnumber = 0;
			NPheno += famdata[famold].Pheno;
			NINCORRECTPheno += famdata[famold].INCORRECTPheno;

		}

		if ((status < 0) || (status > 2)) {
			fprintf(
					errfile,
					"individual %d from family %d does not have a phenotype value of 0, 1, or 2 ..will be skipped\n",
					ind, fam);
			famdata[fam].INCORRECTPheno++;

		}

		else if (status == 0 || status == 1 || status == 2) {

			if (status == 0) {
				famdata[fam].Unknown++;
				NUnknown = NUnknown + 1;
			}

			if (status == 1) {
				NUnaffected++;
			}

			if (status == 2) {
				Naffected++;
			}

			famdata[fam].Pheno++;

		}

		indnumber++;

		famdata[fam].descri[indnumber] = ind;

		famdata[fam].AFFEC[indnumber][1] = status;
		famdata[fam].AFFEC[indnumber][2] = status;
		if ((status < 0) || (status > 2)) {
			famdata[fam].AFFEC[indnumber][1] = -9;
			famdata[fam].AFFEC[indnumber][2] = -9;
		}


		mycount++;
		famdata[fam].STUDYID[indnumber] = mycount;

		fscanf(famfile, "\n");
		famold = fam;
	}

	NPheno += famdata[fam].Pheno;
	NINCORRECTPheno += famdata[fam].INCORRECTPheno;

	rewind(famfile);
}

void setphenomissing(struct FAM *famdata) {
	double val1 = 0;
	int i,j,m;
	if (noCov == 0) {
		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].Pheno; j++) {
				fscanf(famfile, "%*d %*d %*d ");
				for (m = 1; m <= Ncov; m++) {
					fscanf(famfile, "%lf ", &val1);
					if (val1 == MISSINGVAL)
						famdata[i].AFFEC[j][2] = 0;
				}
			}
		}
		rewind(famfile);
	}

}

void init_storekin() {
	int i,j;
	Storekin = (double ***) malloc((size_t) ((F + 1) * sizeof(double**)));
	for (i = 0; i <= F; i++) {

		Storekin[i] = (double **) malloc(
				(size_t) ((famdata[i].N + 1) * sizeof(double*)));
		if (!Storekin[i]) {
			printf(
					"Error in memory allocation for kinship coefficient storage\n");
			exit(1);
		}
		for (j = 0; j <= famdata[i].N; j++) {
			Storekin[i][j] = (double *) malloc((size_t) ((famdata[i].N + 1)
					* sizeof(double)));
			if (!Storekin[i][j]) {
				printf(
						"Error in memory allocation for kinship coefficient storage\n");
				exit(1);
			}
		}
	}
}


void readkincoef(char *name, FILE *errfile, struct FAM *famdata,
		double ***Storekin) {
	double coef = 0;
	int follow = 0, j, i, famold = 0;
	long int Id1, Id2;
	int family = 0, ind1 = 0, ind2 = 0, indold1 = 0, indold2 = 0, Idold1 = 0,
			Idold2 = 0;
	int err_array[N];
	int test = 0, lim = 0;

	for (i = 1; i <= N; i++)
		err_array[i] = 0;
	if ((idfile = fopen(name, "r")) == NULL) {
		printf("Can't open %s\n", name);
		exit(1);
	}
	for (follow = 1; follow <= F; follow++)
		for (i = 1; i <= famdata[follow].N; i++)
			for (j = i; j <= famdata[follow].N; j++) {
				Storekin[follow][i][j] = -1;
				if (i != j)
					Storekin[follow][j][i] = -1;
			}

	while (fscanf(idfile, "%d %ld %ld %lf\n", &family, &Id1, &Id2, &coef) == 4) {
		if (family > F) {
			printf(
					"Problem with family number %d. Family should have following Id numbers from 1 to N\n",
					family);
			exit(1);
		}
		if (family == famold) {
			if (Id1 == Idold1)
				ind1 = indold1;
			else if (Id1 == Idold2)
				ind1 = indold2;
			else
				ind1 = findInd(Id1, family);

			if (Id2 == Idold1)
				ind2 = indold1;
			else if (Id2 == Idold2)
				ind2 = indold2;
			else
				ind2 = findInd(Id2, family);
		} else {
			ind1 = findInd(Id1, family);
			ind2 = findInd(Id2, family);
		}
		famold = family;

		if (ind1 != 0 && ind2 != 0) {
			Storekin[family][ind1][ind2] = coef;
			Storekin[family][ind2][ind1] = coef;
		}
		if (ind1 == 0) {
			test = 0;
			for (j = 1; j <= lim; j++)
				if (Id1 == err_array[j]) {
					test = 1;
					j = lim + 1;
				}

			if (test == 0) {
				fprintf(
						errfile,
						"individual %ld from family %d is in the kinshipcoef file but is not phenotyped or not available from marker data file\n",
						Id1, family);
				lim++;
				err_array[lim] = Id1;
			}
		}
		if (ind2 == 0) {
			test = 0;
			for (j = 1; j <= lim; j++)
				if (Id2 == err_array[j]) {
					test = 1;
					j = lim + 1;
				}
			if (test == 0) {
				fprintf(
						errfile,
						"individual %ld from family %d is in the kinshipcoef file but is not phenotyped or not available from marker data file\n",
						Id2, family);
				lim++;
				err_array[lim] = Id2;
			}
		}

		Idold1 = Id1;
		Idold2 = Id2;
		indold1 = ind1;
		indold2 = ind2;
	}
}

/******************************************************
 returns the rank of an individual in his family from its family number and Id
 *****************************************************/
int findInd(int Id1, int family) {
	int indpas = 1;
	while (indpas <= famdata[family].N) {
		if (famdata[family].descri[indpas] == Id1)
			return (indpas);
		indpas++;
	}
	return (0);
}

void init_Mark() {
	int i,j;
	Mark[1].Nball = 0;
		Mark[1].Nc = 0;
		Mark[1].Nt = 0;
		Mark[1].Nu = 0;
		Mark[1].typed = (Nsize *) malloc(
				(size_t) ((MAXFAM + 1) * sizeof(Nsize)));
		if (!Mark[1].typed) {
			printf("Error in memory allocation 1\n");
			exit(1);
		}

		Mark[1].mark = (int ***) malloc(
				(size_t) ((MAXFAM + 1) * sizeof(int**)));
		if (!Mark[1].mark) {
			printf("Error in memory allocation 2\n");
			exit(1);
		}

		for (i = 0; i <= F; i++) {
			Mark[1].typed[i].N = 0;
			Mark[1].typed[i].Nc = 0;
			Mark[1].typed[i].Nt = 0;
			Mark[1].typed[i].Nu = 0;
			Mark[1].mark[i] = (int **) malloc(
					(size_t) (((famdata[i].N) + 1) * sizeof(int*)));
			if (!Mark[1].mark[i]) {
				printf("Error in memory allocation 3\n");
				exit(1);
			}

			for (j = 0; j <= famdata[i].N; j++) {
				Mark[1].mark[i][j] = (int *) malloc(
						(size_t) ((6) * sizeof(int)));
				if (!Mark[1].mark[i][j]) {
					printf("Error in memory allocation 4 %d %d %d\n",
							famdata[i].N, i, j);
					exit(1);
				}
			}

		}
}

void free_memory(){
	int i,j;
	for (i = 0; i <= F; i++) {


		free(famdata[i].descri);


		for (j = 0; j <= famdata[i].N; j++) {
			free(famdata[i].AVEC[j]);
		}
		free(famdata[i].AVEC);


		for (j = 0; j <= famdata[i].N; j++) {
			free(famdata[i].AFFEC[j]);
		}
		free(famdata[i].AFFEC);

		free(famdata[i].STUDYID);


		for (j = 0; j <= famdata[i].N; j++) {
			free(famdata[i].CorrectedAFFEC[j]);
		}
		free(famdata[i].CorrectedAFFEC);

	}
	for (i = 0; i <= F; i++) {
		for (j = 0; j <= famdata[i].N; j++) {
			free(Storekin[i][j]);
		}
		free(Storekin[i]);
	}
	free(Storekin);

	int m;
	for (m = 1; m <= 1; m++) {
		free(Mark[m].typed);
		for (i = 0; i <= F; i++) {
			for (j = 0; j <= famdata[i].N; j++) {
				free(Mark[m].mark[i][j]);
			}
			free(Mark[m].mark[i]);
		}
		free(Mark[m].mark);
	}
}

