/*
 * compute_residuals.h
 *
 *  Created on: Dec 30, 2013
 *      Author: shengz
 */

#ifndef COMPUTE_RESIDUALS_H_
#define COMPUTE_RESIDUALS_H_

typedef struct {
	int totpc;
	double ***V_f;
	double **S_f;
	double *beta_init;
	int *totpc_f;
	double **yaffec_f;
	double ***Store_cov_f;
	double ***Storekin_pc;
	double *current_beta;
	double *current_sigma_t_sq;
	int L;
} param_func_xi;


typedef struct {
	param_func_xi parameters;
	double (*func_of_xi)(double, param_func_xi);
} function_xi;

void readcov3(double **StoreCov, double *yaffec, int *flag, int *genoflag);
void readcov2(double **StoreCov, double *yaffec, int *flag);
void compute_logistic_coeff(double *yaffec, int *covflag, int totpc, double *beta_init);
void compute_correctedpheno(int L, int ALL, int first_degree, int Missing);
void estimate_gee_parameters(int totpc, double ***V_f, double **S_f, double *beta_init,
		int *totpc_f, double **yaffec_f, double ***Store_cov_f, double ***Storekin_pc,
	double *xi, double *sigma_t_sq, double *betahat,int L);
int compute_gee_betahat(double ***Sigma_inv_f, double *beta_init, double xi,
		double *betahat, int *totpc_f, double **yaffec_f, double ***Store_cov_f,
		double **mu_f);
double target_func_xi(double xi, int totpc, double ***V_f, double **S_f, double *beta_init,
		int *totpc_f, double **yaffec_f, double ***Store_cov_f, double ***Storekin_pc,
		double *current_beta, double *current_sigma_t_sq, int L);
double eqn3_lhs_minus_rhs(double xi, param_func_xi parameters);
double compute_gee_residuals (double *yaffec, int *covflag, int L, int flag);
void compute_linear_mixed_betahat(double ***Sigma_inv_f, double xi,
		double *betahat, int *totpc_f, double **yaffec_f, double ***Store_cov_f);
void genotyped_relative_flag(int *geno_info_flag);
void SetR_flag(int *geno_info_flag);
void compute_linear_residuals(double *yaffec, int *covflag);
void compute_logistic_residuals(double *yaffec, int *covflag);
double estimate_GWAS_heritability(int L);
void compute_gee_residuals_given_xi(double *yaffec, int *covflag, int L);



#endif /* COMPUTE_RESIDUALS_H_ */
