/*
 * compute_residuals.c
 *
 *  Created on: Dec 27, 2013
 *      Author: shengz
 */

#include "global_variables.h"
#include "read_data.h"
#include "svdcomp.h"
#include "nrutil.h"
#include "math.h"
#include "compute_residuals.h"
#include "brent.h"
#include <time.h>


#define MISSVAL_FUNC_XI -999999

extern void dposv_(char *uplo, int *n, int *nrhs, double *A, int *lda,
		double *B, int *ldb, int *info);


void compute_correctedpheno(int L, int ALL, int first_degree, int Missing){
    int i;
    //covflag[i] equals 1 if the ith individual in pedfile is added to calculate the projected affection status.
    int *covflag;
    //store the affection status of individuals added to calculate the projected affection status
    double* yaffec;
	//initialize various quantities
	covflag = ivector(0,N);
	for (i = 0; i <= N; i++)
		covflag[i] = 1;
	yaffec = dvector(0,N - NUnknown);
	for (i = 0; i <= (N - NUnknown); i++)
		yaffec[i] = 0;
	//initialize StoreCov
	StoreCov = dmatrix(0,N - NUnknown,0,Ncov);
	//include all individuals that have non-missing phenotypes and covariates,
	//but may have missing genotypes
	if (ALL == 1) {
		//read in covariate data and the corresponding phenotype data
		readcov2(StoreCov, yaffec, covflag);

    	if (L == 0) compute_linear_residuals(yaffec,covflag);
    	if (L == 1) compute_logistic_residuals(yaffec,covflag);
		if (L >= 2) compute_gee_residuals(yaffec, covflag, L,1);

	}
	if (ALL == 0) {
		if (Missing == 1) {
	    	int *geno_info_flag = ivector(1,N);
			if (first_degree == 0) SetR_flag(geno_info_flag);
 			if (first_degree == 1) genotyped_relative_flag(geno_info_flag);
 /*			printf("We are here!");
 			int check_tot=0;
 			for (i=1;i<=N;i++) {check_tot +=geno_info_flag[i];}
 			printf("%d %d %d %d %d %d %d\n",geno_info_flag[2593],
 					geno_info_flag[2778], geno_info_flag[3464],geno_info_flag[3465],
 					geno_info_flag[3722],geno_info_flag[7848],geno_info_flag[7952]);
 			printf("check_tot is %d.",check_tot);
 			exit(1);*/
 			int check_tot=0;
 			for (i=1;i<=N;i++) {check_tot +=geno_info_flag[i];}
 			//printf("geno_info_flag tot is %d.\n", check_tot);
 			//for (i=1;i<=100;i++) {printf("%d ", geno_info_flag[i]);}

        	readcov3(StoreCov, yaffec, covflag, geno_info_flag);

        	free_ivector(geno_info_flag,1,N);
        	if (L == 0) compute_linear_residuals(yaffec,covflag);
        	if (L == 1) compute_logistic_residuals(yaffec,covflag);
    		if (L >= 2) compute_gee_residuals(yaffec, covflag, L,1);
		}
		//only include individuals that have non-missing data (phenotypes,
		//genotypes, and covariates)
		if (Missing == 2) {
			readcov3(StoreCov, yaffec, covflag, genoflag);
        	if (L == 0) compute_linear_residuals(yaffec,covflag);
        	if (L == 1) compute_logistic_residuals(yaffec,covflag);
			if (L >= 2) compute_gee_residuals(yaffec, covflag, L,1);
		}
	}
	if (ALL == 2) {
		if (Missing == 1) {
	    	int *geno_info_flag = ivector(1,N);
			if (first_degree == 0) SetR_flag(geno_info_flag);
 			if (first_degree == 1) genotyped_relative_flag(geno_info_flag);
 /*			printf("We are here!");
 			int check_tot=0;
 			for (i=1;i<=N;i++) {check_tot +=geno_info_flag[i];}
 			printf("%d %d %d %d %d %d %d\n",geno_info_flag[2593],
 					geno_info_flag[2778], geno_info_flag[3464],geno_info_flag[3465],
 					geno_info_flag[3722],geno_info_flag[7848],geno_info_flag[7952]);
 			printf("check_tot is %d.",check_tot);
 			exit(1);*/
        	readcov3(StoreCov, yaffec, covflag, geno_info_flag);
        	free_ivector(geno_info_flag,1,N);
        	if (L == 0) compute_linear_residuals(yaffec,covflag);
        	if (L == 1) compute_logistic_residuals(yaffec,covflag);
    		if (L >= 2) compute_gee_residuals_given_xi(yaffec, covflag, L);
		}
		//only include individuals that have non-missing data (phenotypes,
		//genotypes, and covariates)
		if (Missing == 2) {
			readcov3(StoreCov, yaffec, covflag, genoflag);
        	if (L == 0) compute_linear_residuals(yaffec,covflag);
        	if (L == 1) compute_logistic_residuals(yaffec,covflag);
			if (L >= 2) compute_gee_residuals_given_xi(yaffec, covflag, L);
		}
	}

	free_ivector(covflag,0,N);
	free_dvector(yaffec,0,N - NUnknown);
	free_dmatrix(StoreCov,0,N - NUnknown,0,Ncov);


}

double estimate_GWAS_heritability(int L){

	double h2;
    int i;
    //covflag[i] equals 1 if the ith individual in pedfile is added to calculate the projected affection status.
    int *covflag;
    //store the affection status of individuals added to calculate the projected affection status
    double* yaffec;
	//initialize various quantities
	covflag = ivector(0,N);
	for (i = 0; i <= N; i++)
		covflag[i] = 1;
	yaffec = dvector(0,N - NUnknown);
	for (i = 0; i <= (N - NUnknown); i++)
		yaffec[i] = 0;
	//initialize StoreCov
	StoreCov = dmatrix(0,N - NUnknown,0,Ncov);
	readcov2(StoreCov, yaffec, covflag);
	h2 = compute_gee_residuals(yaffec, covflag, L, 2);

	free_ivector(covflag,0,N);
	free_dvector(yaffec,0,N - NUnknown);
	free_dmatrix(StoreCov,0,N - NUnknown,0,Ncov);
	return h2;
}

void compute_gee_residuals_given_xi(double *yaffec, int *covflag, int L) {
	int i,j,k,l;

    //the total number of individuals with non-missing phenotype and covariates
    int totpc = 0;
	for (i = 1; i <= N; i++) totpc += covflag[i];
/*	int check1=0;
	for (i=1;i<=N;i++) if (covflag[i]==1) check1 +=i;
	printf("We are here!!!, %d %d", totpc,check1);
	for (i = 1; i <= N; i++)
	exit(1);*/
	//set yaffec to be 0 or 1
	for (i = 1; i <= totpc; i++) yaffec[i] = yaffec[i] - 1;

	int *totpc_f = ivector(1,F);
	int **covflag_f = (int **) malloc((size_t) ((F+1)*sizeof(int *)));
	covflag_f[0] = NULL;

	int st = 1;
	for (i=1; i<=F; i++) {
		totpc_f[i] = 0;
		for (j=st;j<=(famdata[i].N+st-1);j++) {
			totpc_f[i] +=  covflag[j];
		}
		covflag_f[i] = ivector(1, famdata[i].N);
		for (j=1; j<=famdata[i].N; j++) {
			covflag_f[i][j] = covflag[j+st-1];
		}
		st = st + famdata[i].N;
	}
	double ***Storekin_pc = (double ***) malloc((size_t) ((F + 1) * sizeof(double**)));
	Storekin_pc[0] = NULL;
	for (i = 1; i <= F; i++) {
		if (totpc_f[i]==0) {Storekin_pc[i] = NULL;} else {
		    Storekin_pc[i] = dmatrix(1,totpc_f[i],1,totpc_f[i]);
		}
	}
	int tot1,tot2;
	for (i = 1; i <= F; i++) {
        if (totpc_f[i]>0) {
            tot1=0;
		    for (j=1; j<=famdata[i].N; j++) {
		    	if (covflag_f[i][j]!=0) {
		    		tot1++;
		    		tot2=0;
		    	    for (k=1; k<=famdata[i].N; k++) {
		    	    	if (covflag_f[i][k]!=0) {
		    	    		tot2++;
		    			    Storekin_pc[i][tot1][tot2] = Storekin[i][j][k];
		    		    }
		    	    }
		    	}
		    }
		}
	}
	double **yaffec_f, **mu_f, ***Store_cov_f;
    //compute yaffec_f
	yaffec_f = (double **) malloc ((size_t) ((F+1)*sizeof(double *)));
	yaffec_f[0]=NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {yaffec_f[i]=NULL;} else {
			yaffec_f[i] = dvector(1, totpc_f[i]);
		}
	}
	tot1 = 1;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i]; j++) {
				yaffec_f[i][j] = yaffec[tot1];
				tot1++;
			}
		}
	}
	Store_cov_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Store_cov_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Store_cov_f[i]=NULL;} else {
			Store_cov_f[i] = dmatrix(1, totpc_f[i],1,Ncov);
		}
	}
	tot1 = 1;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i]; j++) {
				for (k=1; k<=Ncov; k++) {
					Store_cov_f[i][j][k] = StoreCov[tot1][k];
				}
				tot1++;
			}
		}
	}
    mu_f = (double **) malloc ((size_t) ((F+1)*sizeof(double *)));
    mu_f[0]=NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {mu_f[i]=NULL;} else {
			mu_f[i] = dvector(1, totpc_f[i]);
		}
	}

    //compute Phi_inverse
	double ***Phi_inv_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Phi_inv_f[0] = NULL;
	double ***V_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	V_f[0] = NULL;
	double **S_f = (double **) malloc((size_t) ((F+1)*sizeof(double *)));
	S_f[0] = NULL;

	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Phi_inv_f[i]=NULL;V_f[i]=NULL; S_f[i]=NULL;} else {
			Phi_inv_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
			V_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
			S_f[i] = dvector(1,totpc_f[i]);
		}
	}

	//compute Phi_inv_f, initialize to xi*kinship matrix + (1-xi)*identity matrix
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i];j++) {
				for (k=1; k<=totpc_f[i]; k++) {
					if (j==k) {Phi_inv_f[i][j][k] = 1.0 + Storekin_pc[i][j][k];} else {
						Phi_inv_f[i][j][k] = 2 * Storekin_pc[i][j][k];
					}
				}
			}
		}
	}

	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			svdcomp(Phi_inv_f[i],totpc_f[i], totpc_f[i], S_f[i], V_f[i]);
		}
	}
    //compute Sigma_inv_f;
	double ***Sigma_inv_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Sigma_inv_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Sigma_inv_f[i]=NULL;} else {
			Sigma_inv_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
		}
	}
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i];j++) {
				for (k=1; k<=totpc_f[i];k++) {
					Sigma_inv_f[i][j][k]=0.0;
					for (l=1;l<=totpc_f[i];l++) {
						Sigma_inv_f[i][j][k]= Sigma_inv_f[i][j][k] +
								V_f[i][j][l]/(GWAS_heritability*S_f[i][l]+1-GWAS_heritability)*V_f[i][k][l];
					}
				}
			}
		}
	}

	double *optim_betahat = dvector(1,Ncov);
	double optim_sigma_t_sq;

	if (L == 2) {
		double *beta_init = dvector(1,Ncov);
		compute_logistic_coeff(yaffec,covflag,totpc,beta_init);

		compute_gee_betahat(Sigma_inv_f, beta_init, GWAS_heritability,
				optim_betahat, totpc_f, yaffec_f, Store_cov_f,
				mu_f);
		free_dvector(beta_init,1,Ncov);

		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					mu_f[i][j] = 0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += optim_betahat[k] * Store_cov_f[i][j][k];
					}
					    mu_f[i][j] = exp(mu_f[i][j])/(1+exp(mu_f[i][j]));
				}
			}
		}
		optim_sigma_t_sq=0.0;
        for (i=1;i<=F;i++) {
      	  if (totpc_f[i]>0) {
      		  for (j=1;j<=totpc_f[i];j++) {
      			  for (k=1; k<=totpc_f[i];k++) {
      				optim_sigma_t_sq += (yaffec_f[i][j] - mu_f[i][j])/sqrt(mu_f[i][j]*(1-mu_f[i][j]))*Sigma_inv_f[i][j][k]*(yaffec_f[i][k] - mu_f[i][k])/sqrt(mu_f[i][k]*(1-mu_f[i][k]));
      			  }
      		  }
      	  }
        }
        optim_sigma_t_sq = optim_sigma_t_sq/(totpc);
	}
	if (L == 3) {
		compute_linear_mixed_betahat(Sigma_inv_f, GWAS_heritability,
				optim_betahat, totpc_f, yaffec_f, Store_cov_f);
		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					mu_f[i][j] = 0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += optim_betahat[k] * Store_cov_f[i][j][k];
					}
				}
			}
		}

		optim_sigma_t_sq=0.0;
      for (i=1;i<=F;i++) {
    	  if (totpc_f[i]>0) {
    		  for (j=1;j<=totpc_f[i];j++) {
    			  for (k=1; k<=totpc_f[i];k++) {
    				  optim_sigma_t_sq += (yaffec_f[i][j] - mu_f[i][j])*Sigma_inv_f[i][j][k]*(yaffec_f[i][k] - mu_f[i][k]);
    			  }
    		  }
    	  }
      }
      optim_sigma_t_sq = optim_sigma_t_sq/(totpc);

	}
	double *yAffecProj = dvector(1,N);
	tot1 = 1;
	if (L == 2) {
	for (i=1;i<=F;i++) {
		if (totpc_f[i]>0) {
			for (j=1;j<=totpc_f[i];j++) {
				yAffecProj[tot1] = 0.0;
				for (k=1;k<=totpc_f[i];k++) {
					yAffecProj[tot1] += Sigma_inv_f[i][j][k]/optim_sigma_t_sq*sqrt(mu_f[i][j]*(1-mu_f[i][j]))/sqrt(mu_f[i][k]*(1-mu_f[i][k]))*(yaffec_f[i][k]-mu_f[i][k]);
				}
				tot1++;
			}
		}
	}
	}
	if (L == 3) {
		for (i=1;i<=F;i++) {
			if (totpc_f[i]>0) {
				for (j=1;j<=totpc_f[i];j++) {
					yAffecProj[tot1] = 0.0;
					for (k=1;k<=totpc_f[i];k++) {
						yAffecProj[tot1] += Sigma_inv_f[i][j][k]*(yaffec_f[i][k]-mu_f[i][k]);
					}
					tot1++;
				}
			}
		}
	}
	int tot = 1;
	tot1 = 1;
	for (i = 1; i <= F; i++) {
		for (j = 1; j <= famdata[i].N; j++) {
			if (covflag[tot] == 1) {
				famdata[i].CorrectedAFFEC[j][1] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][2] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][3] = yAffecProj[tot1];
				tot1++;
			}
			tot++;
		}
	}



	//calculate estimated covariance matrix of betahat
	double **covariance_betahat = dmatrix(1, Ncov, 1,Ncov);
	double ***XtVinverse_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	XtVinverse_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {XtVinverse_f[i]=NULL;} else {
			XtVinverse_f[i] = dmatrix(1, Ncov,1,totpc_f[i]);
		}
	}


	for (i=1; i<=F; i++) {
		if (totpc_f[i]>0) {
			for (j=1; j<=Ncov; j++) {
				for (k=1; k<=totpc_f[i]; k++) {
					XtVinverse_f[i][j][k]=0.0;
					for (l=1;l<=totpc_f[i];l++) {
						if (L==2) XtVinverse_f[i][j][k] += Store_cov_f[i][l][j] * sqrt(mu_f[i][l]*(1-mu_f[i][l]))*
								sqrt(mu_f[i][k]*(1-mu_f[i][k])) *Sigma_inv_f[i][l][k];
						if (L==3) XtVinverse_f[i][j][k] += Store_cov_f[i][l][j] * Sigma_inv_f[i][l][k];
					}
				}
			}
		}
	}

	for (i=1; i<=Ncov; i++) {
		for (j=1; j<=Ncov; j++) {
			covariance_betahat[i][j] = 0.0;
			for (k=1; k<=F; k++) {
				if (totpc_f[k]>0) {
					for (l=1; l<=totpc_f[k]; l++) {
						covariance_betahat[i][j] += XtVinverse_f[k][i][l] * Store_cov_f[k][l][j];
					}
				}
			}
		}
	}

	int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
	char *uplo = "L";
	double *a;
	a = dvector(0,Ncov*Ncov);
	double *b;
	b = dvector(0,Ncov*Ncov);

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			a[(j - 1) * Ncov + (i - 1)] = covariance_betahat[i][j];
		}
	}

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			if (i == j)
				b[(j - 1) * Ncov + (i - 1)] = 1;
			else
				b[(j - 1) * Ncov + (i - 1)] = 0;
		}
	}

	n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov;
	dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);


	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			covariance_betahat[i][j] = b[(j - 1) * Ncov + (i - 1)]* optim_sigma_t_sq;
		}
	}

/*	printf("We are here!!!\n");
	for (i=1;i<=Ncov;i++) {
		for (j=1;j<=Ncov;j++) {
			printf("%f ", covariance_betahat[i][j]);
		}
		printf("\n");
	}
	for (i=1;i<=Ncov;i++) printf("%f ", sqrt(covariance_betahat[i][i]));
	printf("\n");
	for (i=1;i<=Ncov;i++) printf("%f ",	optim_betahat[i]);
	printf("\n");
	printf("optim_sigma_t_sq is %f, optim_xi is %f, optim_add_var is %f, optim_add_err is %f.",
			optim_sigma_t_sq,optim_xi,optim_sigma_t_sq*optim_xi,optim_sigma_t_sq*(1-optim_xi));
	exit(1);
*/
	if (L == 2 && fit_dispersion == 1) {
	fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n",GWAS_heritability);
	fprintf(phenomodel_estimates_file,"Additive_Var \t %g \t NA \n", optim_sigma_t_sq*GWAS_heritability);
	fprintf(phenomodel_estimates_file,"Error_Var \t %g \t NA \n", optim_sigma_t_sq*(1-GWAS_heritability));
	}
	if (L == 2 && fit_dispersion == 0) {
	fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n",GWAS_heritability);
	fprintf(phenomodel_estimates_file,"Additive_Var \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Error_Var \t NA \t\t NA \n");
	}
	if (L == 3) {
		fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
		fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
		fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n", GWAS_heritability);
		fprintf(phenomodel_estimates_file,"Additive_Var \t %g \t NA \n", optim_sigma_t_sq*GWAS_heritability);
		fprintf(phenomodel_estimates_file,"Error_Var \t %g \t NA \n", optim_sigma_t_sq*(1-GWAS_heritability));
	}

	fprintf(phenomodel_estimates_file,"Intercept \t %g \t %g \n",optim_betahat[1],sqrt(covariance_betahat[1][1]));
	for (i=2; i<=Ncov; i++) {
		fprintf(phenomodel_estimates_file,"Covariate_%d \t %g \t %g \n",i-1,optim_betahat[i],sqrt(covariance_betahat[i][i]));
	}


	for (i=1; i<=F; i++) {
	if (totpc_f[i]>0) {
	free_dmatrix(XtVinverse_f[i], 1, Ncov,1,totpc_f[i]);
	}
	}
	free(XtVinverse_f);
	free_dmatrix(covariance_betahat,1,Ncov,1,Ncov);
	free_dvector(a,0,Ncov*Ncov);
	free_dvector(b,0,Ncov*Ncov);

/*   	printf("\nTests started here:\n");
    printf("betahat is null? %d\n",(int)optim_betahat==NULL);
    for (i=1; i<=Ncov; i++) printf("%f ",optim_betahat[i]);
    printf("\nsigma_t_sq is %f.xi_root is %f.",optim_sigma_t_sq,optim_xi);
    printf("\nTests ended!\n");
		 			printf("\n\nNow we print famdata.CorrectedAFFEC:\n");
		    		 for (i=(F-2); i<=F; i++) {
		    		 printf("For family %d: ", i);
		    		 for (j=1; j<=famdata[i].N; j++) {
		    		 printf("%f ", famdata[i].CorrectedAFFEC[j][1]);
		    		 }
		    		 printf("\n");
		    		 }*/


	for (i=1; i<=F; i++) {
	    free_ivector(covflag_f[i], 1, famdata[i].N);
	if (totpc_f[i]>0) {
	free_dmatrix(Storekin_pc[i],1,totpc_f[i],1,totpc_f[i]);
	free_dvector(yaffec_f[i],1, totpc_f[i]);
	free_dmatrix(Store_cov_f[i],1, totpc_f[i],1,Ncov);
	free_dvector(mu_f[i],1, totpc_f[i]);
	free_dmatrix(Sigma_inv_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dmatrix(Phi_inv_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dmatrix(V_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dvector(S_f[i],1, totpc_f[i]);
	}
	}
	free(covflag_f);
	free(Storekin_pc);
	free(yaffec_f);
	free(Store_cov_f);
	free(mu_f);
	free(Sigma_inv_f);
	free(Phi_inv_f);
	free(V_f);
	free(S_f);
	free_ivector(totpc_f,1,F);
	free_dvector(optim_betahat,1,Ncov);
	free_dvector(yAffecProj,1,N);
}



void compute_linear_residuals(double *yaffec, int *covflag){
	int i,j,k;
	int totpc = 0;
	for (i = 1; i <= N; i++) totpc += covflag[i];
	//W^tW

	//clock_t t1,t2,t3,t4,t5,t6;
	//double d1=0.0,d2=0.0,d3=0.0,d4=0.0,d5=0.0,d6=0.0;
	//printf("WE ARE HERE!!!");

	//t1 = clock();

	double **WtW;
	WtW = dmatrix(1,Ncov,1,Ncov);
	//calculate W^tW
	for (i = 1; i <= Ncov; i++) {
		for (j = 1; j <= Ncov; j++) {
			WtW[i][j] = 0;
			for (k = 1; k <= totpc; k++) {
				WtW[i][j] += StoreCov[k][i] * StoreCov[k][j];

			}
		}
	}

	int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
	char *uplo = "L";
	double *a;
	a = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	double *b;
	b = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	double **inverWtW;
	inverWtW = dmatrix(1,Ncov,1,Ncov);
	n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov;

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			a[(j - 1) * Ncov + (i - 1)] = WtW[i][j];
		}
	}

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			if (i == j)
				b[(j - 1) * Ncov + (i - 1)] = 1;
			else
				b[(j - 1) * Ncov + (i - 1)] = 0;
		}
	}
	n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov;
	dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);


	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			inverWtW[i][j] = b[(j - 1) * Ncov + (i - 1)];
		}
	}


	double **WinverWtW;
	WinverWtW = dmatrix(1,totpc,1,Ncov);
	for (i = 1; i <= totpc; i++) {
		for (j = 1; j <= Ncov; j++) {
			WinverWtW[i][j] = 0.0;
			for (k = 1; k <= Ncov; k++) {
				WinverWtW[i][j] += StoreCov[i][k] * inverWtW[k][j];
			}

		}
	}

	double *WtY = dvector(1,Ncov);
	for (i=1;i<=Ncov;i++){
		WtY[i]=0.0;
		for (j=1;j<=totpc;j++) {
			WtY[i] += StoreCov[j][i] * yaffec[j];
		}
	}


    //t2 = clock();
	//d2 = (double)(t2-t1)/CLOCKS_PER_SEC;
	//printf("d2 is %f\t",d2);


	double *yAffecProj;
	yAffecProj = dvector(1,totpc);
	for (i = 1; i <= totpc; i++) {
		yAffecProj[i] = 0.0;
		for (j = 1; j <= Ncov; j++) {
			yAffecProj[i] += WtY[j] * WinverWtW[i][j];
		}
		yAffecProj[i] = yaffec[i] - yAffecProj[i];
	}

	//we calculate the estimates and standard errors for the regression coefficients
	double sigmahat = 0.0;
	for (i=1; i<=totpc; i++) {
		sigmahat += yAffecProj[i] * yAffecProj[i] / (totpc - Ncov);
	}
	double *betahat = dvector(1,Ncov);

	for (i=1; i<=Ncov; i++) {
		betahat[i] = 0.0;
		for (j=1; j<=Ncov; j++) {
			betahat[i] += inverWtW[i][j] * WtY[j];
		}
	}

	fprintf(phenomodel_estimates_file,"\n(User specified to use MQLS-LIN method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Additive_Var \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Error_Var \t %g \t NA \n", sigmahat);
	fprintf(phenomodel_estimates_file,"Intercept \t %g \t %g \n",betahat[1],sqrt(sigmahat*inverWtW[1][1]));
	for (i=2; i<=Ncov; i++) {
		fprintf(phenomodel_estimates_file,"Covariate_%d \t %g \t %g \n",i-1,betahat[i],sqrt(sigmahat*inverWtW[i][i]));
	}
	free_dvector(betahat,1,Ncov);

	int tot = 1;
	int tot1 = 1;
	for (i = 1; i <= F; i++) {
		for (j = 1; j <= famdata[i].N; j++) {
			if (covflag[tot] == 1) {
				famdata[i].CorrectedAFFEC[j][1] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][2] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][3] = yAffecProj[tot1];
				tot1++;
			}
			tot++;
		}
	}
	free_dmatrix(WtW, 1,Ncov,1,Ncov);
	free_dmatrix(inverWtW, 1,Ncov,1,Ncov);
	free_dvector(WtY,1,Ncov);
	free(a);
	free(b);
	free_dmatrix(WinverWtW,1,totpc,1,Ncov);
	free_dvector(yAffecProj, 1,totpc);

	//t6=clock();
	//d1 = (double)(t6-t1)/CLOCKS_PER_SEC;
	//printf("d1 is %f\t",d1);
}

void compute_logistic_residuals(double *yaffec, int *covflag) {
	int i,j;
	//calculate totpc
	int totpc=0;
	for (i = 1; i <= N; i++)
		totpc += covflag[i];
	//for (i=1;i<=50;i++) printf("%f ",yaffec[i]);
	//printf("\n");
	for (i = 1; i <= totpc; i++)
	 yaffec[i] = yaffec[i] - 1;
	double *betahat = dvector(1,Ncov);
	compute_logistic_coeff(yaffec, covflag, totpc, betahat);
	//for (i=1;i<=Ncov;i++) printf("%f ", betahat[i]);
    //printf("\n");
	double *pi = dvector(1, totpc);
    for (i = 1; i <= totpc; i++) {
    	pi[i] = 0.0;
    	for (j = 1; j <= Ncov; j++) {
    		pi[i] += StoreCov[i][j] * betahat[j];
        }
        pi[i] = exp(pi[i]) / (1 + exp(pi[i]));
    }
	double *yAffecProj;
	yAffecProj = dvector(1,totpc);
	for (i = 1; i <= totpc; i++) {
		yAffecProj[i] = yaffec[i] - pi[i];
	}

	//we print (to file) the estimates and standard errors for the regression coefficients
	fprintf(phenomodel_estimates_file,"\n(User specified to use MQLS-LOG method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Additive_Var \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Error_Var \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Intercept \t %g \t %g \n",betahat[1],sqrt(logistic_coeff_var[1]));
	for (i=2; i<=Ncov; i++) {
		fprintf(phenomodel_estimates_file,"Covariate_%d \t %g \t %g \n",i-1,betahat[i],sqrt(logistic_coeff_var[i]));
	}

	int tot = 1;
	int tot1 = 1;
	for (i = 1; i <= F; i++) {
		for (j = 1; j <= famdata[i].N; j++) {
			if (covflag[tot] == 1) {
				famdata[i].CorrectedAFFEC[j][1] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][2] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][3] = yAffecProj[tot1];
				tot1++;
			}
			tot++;
		}
	}
	free_dvector(pi,1,totpc);
	free_dvector(betahat,1,Ncov);
	free_dvector(yAffecProj,1, totpc);
}


//flag = 2 indicates using the function for the purpose of estimating xi only
//flag = 1 indicates using the function for the general purpose
double compute_gee_residuals (double *yaffec, int *covflag, int L, int flag) {
	int i,j,k,l;

    //the total number of individuals with non-missing phenotype and covariates
    int totpc = 0;
	for (i = 1; i <= N; i++) totpc += covflag[i];
	//printf("We are here!!!, %d\n", totpc);
/*	int check1=0;
	for (i=1;i<=N;i++) if (covflag[i]==1) check1 +=i;
	printf("We are here!!!, %d %d", totpc,check1);
	for (i = 1; i <= N; i++)
	exit(1);*/
	//set yaffec to be 0 or 1
	for (i = 1; i <= totpc; i++) yaffec[i] = yaffec[i] - 1;

	int *totpc_f = ivector(1,F);
	int **covflag_f = (int **) malloc((size_t) ((F+1)*sizeof(int *)));
	covflag_f[0] = NULL;

	int st = 1;
	for (i=1; i<=F; i++) {
		totpc_f[i] = 0;
		for (j=st;j<=(famdata[i].N+st-1);j++) {
			totpc_f[i] +=  covflag[j];
		}
		covflag_f[i] = ivector(1, famdata[i].N);
		for (j=1; j<=famdata[i].N; j++) {
			covflag_f[i][j] = covflag[j+st-1];
		}
		st = st + famdata[i].N;
	}
	double ***Storekin_pc = (double ***) malloc((size_t) ((F + 1) * sizeof(double**)));
	Storekin_pc[0] = NULL;
	for (i = 1; i <= F; i++) {
		if (totpc_f[i]==0) {Storekin_pc[i] = NULL;} else {
		    Storekin_pc[i] = dmatrix(1,totpc_f[i],1,totpc_f[i]);
		}
	}
	int tot1,tot2;
	for (i = 1; i <= F; i++) {
        if (totpc_f[i]>0) {
            tot1=0;
		    for (j=1; j<=famdata[i].N; j++) {
		    	if (covflag_f[i][j]!=0) {
		    		tot1++;
		    		tot2=0;
		    	    for (k=1; k<=famdata[i].N; k++) {
		    	    	if (covflag_f[i][k]!=0) {
		    	    		tot2++;
		    			    Storekin_pc[i][tot1][tot2] = Storekin[i][j][k];
		    		    }
		    	    }
		    	}
		    }
		}
	}
	double **yaffec_f, **mu_f, ***Store_cov_f;
    //compute yaffec_f
	yaffec_f = (double **) malloc ((size_t) ((F+1)*sizeof(double *)));
	yaffec_f[0]=NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {yaffec_f[i]=NULL;} else {
			yaffec_f[i] = dvector(1, totpc_f[i]);
		}
	}
	tot1 = 1;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i]; j++) {
				yaffec_f[i][j] = yaffec[tot1];
				tot1++;
			}
		}
	}
	Store_cov_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Store_cov_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Store_cov_f[i]=NULL;} else {
			Store_cov_f[i] = dmatrix(1, totpc_f[i],1,Ncov);
		}
	}
	tot1 = 1;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i]; j++) {
				for (k=1; k<=Ncov; k++) {
					Store_cov_f[i][j][k] = StoreCov[tot1][k];
				}
				tot1++;
			}
		}
	}
    mu_f = (double **) malloc ((size_t) ((F+1)*sizeof(double *)));
    mu_f[0]=NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {mu_f[i]=NULL;} else {
			mu_f[i] = dvector(1, totpc_f[i]);
		}
	}

    //compute Phi_inverse
	double ***Phi_inv_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Phi_inv_f[0] = NULL;
	double ***V_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	V_f[0] = NULL;
	double **S_f = (double **) malloc((size_t) ((F+1)*sizeof(double *)));
	S_f[0] = NULL;

	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Phi_inv_f[i]=NULL;V_f[i]=NULL; S_f[i]=NULL;} else {
			Phi_inv_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
			V_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
			S_f[i] = dvector(1,totpc_f[i]);
		}
	}

	//compute Phi_inv_f, initialize to xi*kinship matrix + (1-xi)*identity matrix
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i];j++) {
				for (k=1; k<=totpc_f[i]; k++) {
					if (j==k) {Phi_inv_f[i][j][k] = 1.0 + Storekin_pc[i][j][k];} else {
						Phi_inv_f[i][j][k] = 2 * Storekin_pc[i][j][k];
					}
				}
			}
		}
	}

	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			svdcomp(Phi_inv_f[i],totpc_f[i], totpc_f[i], S_f[i], V_f[i]);
		}
	}

	double *optim_betahat;
	optim_betahat = dvector(1, Ncov);
	double optim_sigma_t_sq=-1.0;
	double optim_xi=-1.0;
	double *beta_init = dvector(1,Ncov);
	if (L == 2) {
		compute_logistic_coeff(yaffec,covflag,totpc,beta_init);
	}
	if (L == 3 || L == 2) {
		estimate_gee_parameters(totpc, V_f, S_f, beta_init, totpc_f, yaffec_f,
				Store_cov_f, Storekin_pc, &optim_xi, &optim_sigma_t_sq, optim_betahat, L);
	} else {
		printf("L value is not correct in routine compute_gee_residuals!");
		exit(1);
	}

	//print out sigma_T^2, xi
/*	if (L == 2 && Ncov>=2 && sfile == 1) {
		if (fit_dispersion == 1) {
			FILE *out_var_estimates = fopen("xi_est_d.txt","a+");
			fprintf(out_var_estimates,"%f %f\n",optim_xi,optim_sigma_t_sq);
			fclose(out_var_estimates);
		}
		if (fit_dispersion == 0) {
			FILE *out_var_estimates = fopen("xi_est_nd.txt","a+");
			fprintf(out_var_estimates,"%f %f\n",optim_xi,optim_sigma_t_sq);
			fclose(out_var_estimates);
		}
	}
*/

	//for (i=1;i<=Ncov;i++) printf("%f ",	beta_init[i]);
	//printf("\n");
//	printf("\nEstimates for beta's (using all individuals with non-missing phenotypes and covariates) are:");
//	for (i=1;i<=Ncov;i++) printf("%f ",	optim_betahat[i]);
//	printf("\n");
//	printf("Estimates for variance parameters:\ntotal variance: %f, heritability: %f, "
//			"additive variance: %f, error variance: %f.\n",
//			optim_sigma_t_sq,optim_xi,optim_sigma_t_sq*optim_xi,optim_sigma_t_sq*(1-optim_xi));

	if (L == 2) {
	for (i=1;i<=F;i++) {
		if (totpc_f[i]>0) {
			for (j=1;j<=totpc_f[i];j++) {
				mu_f[i][j]=0.0;
				for (k=1;k<=Ncov;k++) {
					mu_f[i][j] += optim_betahat[k] * Store_cov_f[i][j][k];
				}
				mu_f[i][j] = exp(mu_f[i][j])/(1+exp(mu_f[i][j]));
			}
		}
	}
	}
	if (L == 3) {
		//compute mu_f
		for (i=1;i<=F;i++) {
			if (totpc_f[i]>0) {
				for (j=1;j<=totpc_f[i];j++) {
					mu_f[i][j]=0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += optim_betahat[k] * Store_cov_f[i][j][k];
					}
				}
			}
		}
	}
    //compute Sigma_inv_f;
	double ***Sigma_inv_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Sigma_inv_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Sigma_inv_f[i]=NULL;} else {
			Sigma_inv_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
		}
	}
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i];j++) {
				for (k=1; k<=totpc_f[i];k++) {
					Sigma_inv_f[i][j][k]=0.0;
					for (l=1;l<=totpc_f[i];l++) {
						Sigma_inv_f[i][j][k]= Sigma_inv_f[i][j][k] +
								V_f[i][j][l]/(optim_xi*S_f[i][l]+1-optim_xi)*V_f[i][k][l];
					}
				}
			}
		}
	}

	double *yAffecProj = dvector(1,N);
	tot1 = 1;
	if (L == 2) {
	for (i=1;i<=F;i++) {
		if (totpc_f[i]>0) {
			for (j=1;j<=totpc_f[i];j++) {
				yAffecProj[tot1] = 0.0;
				for (k=1;k<=totpc_f[i];k++) {
					yAffecProj[tot1] += Sigma_inv_f[i][j][k]*sqrt(mu_f[i][j]*(1-mu_f[i][j]))/sqrt(mu_f[i][k]*(1-mu_f[i][k]))*(yaffec_f[i][k]-mu_f[i][k]);
				}
				tot1++;
			}
		}
	}
	}
	if (L == 3) {
		for (i=1;i<=F;i++) {
			if (totpc_f[i]>0) {
				for (j=1;j<=totpc_f[i];j++) {
					yAffecProj[tot1] = 0.0;
					for (k=1;k<=totpc_f[i];k++) {
						yAffecProj[tot1] += Sigma_inv_f[i][j][k]*(yaffec_f[i][k]-mu_f[i][k]);
					}
					tot1++;
				}
			}
		}
	}
	int tot = 1;
	tot1 = 1;
	if (flag==1) {
	for (i = 1; i <= F; i++) {
		for (j = 1; j <= famdata[i].N; j++) {
			if (covflag[tot] == 1) {
				famdata[i].CorrectedAFFEC[j][1] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][2] = yAffecProj[tot1];
				famdata[i].CorrectedAFFEC[j][3] = yAffecProj[tot1];
				tot1++;
			}
			tot++;
		}
	}
	}


	//calculate estimated covariance matrix of betahat
	double **covariance_betahat = dmatrix(1, Ncov, 1,Ncov);
	double ***XtVinverse_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	XtVinverse_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {XtVinverse_f[i]=NULL;} else {
			XtVinverse_f[i] = dmatrix(1, Ncov,1,totpc_f[i]);
		}
	}


	for (i=1; i<=F; i++) {
		if (totpc_f[i]>0) {
			for (j=1; j<=Ncov; j++) {
				for (k=1; k<=totpc_f[i]; k++) {
					XtVinverse_f[i][j][k]=0.0;
					for (l=1;l<=totpc_f[i];l++) {
						if (L==2) XtVinverse_f[i][j][k] += Store_cov_f[i][l][j] * sqrt(mu_f[i][l]*(1-mu_f[i][l]))*
								sqrt(mu_f[i][k]*(1-mu_f[i][k])) *Sigma_inv_f[i][l][k];
						if (L==3) XtVinverse_f[i][j][k] += Store_cov_f[i][l][j] * Sigma_inv_f[i][l][k];
					}
				}
			}
		}
	}

	for (i=1; i<=Ncov; i++) {
		for (j=1; j<=Ncov; j++) {
			covariance_betahat[i][j] = 0.0;
			for (k=1; k<=F; k++) {
				if (totpc_f[k]>0) {
					for (l=1; l<=totpc_f[k]; l++) {
						covariance_betahat[i][j] += XtVinverse_f[k][i][l] * Store_cov_f[k][l][j];
					}
				}
			}
		}
	}

	int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
	char *uplo = "L";
	double *a;
	a = dvector(0,Ncov*Ncov);
	double *b;
	b = dvector(0,Ncov*Ncov);

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			a[(j - 1) * Ncov + (i - 1)] = covariance_betahat[i][j];
		}
	}

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			if (i == j)
				b[(j - 1) * Ncov + (i - 1)] = 1;
			else
				b[(j - 1) * Ncov + (i - 1)] = 0;
		}
	}

	n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov;
	dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);


	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			covariance_betahat[i][j] = b[(j - 1) * Ncov + (i - 1)]* optim_sigma_t_sq;
		}
	}

/*	printf("We are here!!!\n");
	for (i=1;i<=Ncov;i++) {
		for (j=1;j<=Ncov;j++) {
			printf("%f ", covariance_betahat[i][j]);
		}
		printf("\n");
	}
	for (i=1;i<=Ncov;i++) printf("%f ", sqrt(covariance_betahat[i][i]));
	printf("\n");
	for (i=1;i<=Ncov;i++) printf("%f ",	optim_betahat[i]);
	printf("\n");
	printf("optim_sigma_t_sq is %f, optim_xi is %f, optim_add_var is %f, optim_add_err is %f.",
			optim_sigma_t_sq,optim_xi,optim_sigma_t_sq*optim_xi,optim_sigma_t_sq*(1-optim_xi));
	exit(1);
*/
	if (L == 2 && fit_dispersion == 1) {
	fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n", optim_xi);
	fprintf(phenomodel_estimates_file,"Additive_Var \t %g \t NA \n", optim_sigma_t_sq*optim_xi);
	fprintf(phenomodel_estimates_file,"Error_Var \t %g \t NA \n", optim_sigma_t_sq*(1-optim_xi));
	}
	if (L == 2 && fit_dispersion == 0) {
	fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
	fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
	fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n",optim_xi);
	fprintf(phenomodel_estimates_file,"Additive_Var \t NA \t\t NA \n");
	fprintf(phenomodel_estimates_file,"Error_Var \t NA \t\t NA \n");
	}
	if (L == 3) {
		fprintf(phenomodel_estimates_file,"\n(User specified to use CERAMIC method.)");
		fprintf(phenomodel_estimates_file,"\nParameter \t Estimate \t SE \n");
		fprintf(phenomodel_estimates_file,"Heritability \t %g \t NA \n", optim_xi);
		fprintf(phenomodel_estimates_file,"Additive_Var \t %g \t NA \n", optim_sigma_t_sq*optim_xi);
		fprintf(phenomodel_estimates_file,"Error_Var \t %g \t NA \n", optim_sigma_t_sq*(1-optim_xi));
	}

	fprintf(phenomodel_estimates_file,"Intercept \t %g \t %g \n",optim_betahat[1],sqrt(covariance_betahat[1][1]));
	for (i=2; i<=Ncov; i++) {
		fprintf(phenomodel_estimates_file,"Covariate_%d \t %g \t %g \n",i-1,optim_betahat[i],sqrt(covariance_betahat[i][i]));
	}


	for (i=1; i<=F; i++) {
	if (totpc_f[i]>0) {
	free_dmatrix(XtVinverse_f[i], 1, Ncov,1,totpc_f[i]);
	}
	}
	free(XtVinverse_f);
	free_dmatrix(covariance_betahat,1,Ncov,1,Ncov);
	free_dvector(a,0,Ncov*Ncov);
	free_dvector(b,0,Ncov*Ncov);



/*   	printf("\nTests started here:\n");
    printf("betahat is null? %d\n",(int)optim_betahat==NULL);
    for (i=1; i<=Ncov; i++) printf("%f ",optim_betahat[i]);
    printf("\nsigma_t_sq is %f.xi_root is %f.",optim_sigma_t_sq,optim_xi);
    printf("\nTests ended!\n");

*/
//printf("\n\nNow we print famdata.CorrectedAFFEC:\n");

/*	FILE *file_residuals;
	file_residuals = fopen("gee_residuals.txt","w");
		    for (i=1; i<=F; i++) {
		    	 for (j=1; j<=famdata[i].N; j++) {
		    	 	 fprintf(file_residuals,"%d %d %f\n",i,famdata[i].descri[j], famdata[i].CorrectedAFFEC[j][1]);
		    	 }
		    }
		    fclose(file_residuals);

		    printf("GOOD UP TO HERE!!!!!!");exit(1);
*/

	for (i=1; i<=F; i++) {
	    free_ivector(covflag_f[i], 1, famdata[i].N);
	if (totpc_f[i]>0) {
	free_dmatrix(Storekin_pc[i],1,totpc_f[i],1,totpc_f[i]);
	free_dvector(yaffec_f[i],1, totpc_f[i]);
	free_dmatrix(Store_cov_f[i],1, totpc_f[i],1,Ncov);
	free_dvector(mu_f[i],1, totpc_f[i]);
	free_dmatrix(Sigma_inv_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dmatrix(Phi_inv_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dmatrix(V_f[i],1, totpc_f[i],1,totpc_f[i]);
	free_dvector(S_f[i],1, totpc_f[i]);
	}
	}
	free(covflag_f);
	free(Storekin_pc);
	free(yaffec_f);
	free(Store_cov_f);
	free(mu_f);
	free(Sigma_inv_f);
	free(Phi_inv_f);
	free(V_f);
	free(S_f);
	free_ivector(totpc_f,1,F);
	free_dvector(optim_betahat,1,Ncov);
	free_dvector(yAffecProj,1,N);
	free_dvector(beta_init,1,Ncov);

/*	printf("\nTests started here:\n");
	printf("\nsigma_t_sq is %f.xi_root is %f.",optim_sigma_t_sq,optim_xi);
	clock_t done = clock();
	double diff_time = (double) (done-lauch)/CLOCKS_PER_SEC;
	printf("Time elasped is %f.",diff_time);
    exit(1);

*/
	return optim_xi;
}

void estimate_gee_parameters(int totpc, double ***V_f, double **S_f, double *beta_init,
		int *totpc_f, double **yaffec_f, double ***Store_cov_f, double ***Storekin_pc,
	double *xi, double *sigma_t_sq, double *betahat, int L) {

	int i;
	double f_root=-1.0;
	double xi_lo=0, f_lo;
    double *current_beta = dvector(1, Ncov);
    double current_sigma_t_sq;
    param_func_xi parameters = {totpc, V_f, S_f, beta_init, totpc_f, yaffec_f,
    Store_cov_f, Storekin_pc, current_beta, &current_sigma_t_sq, L};
    function_xi *func_xi = malloc(sizeof(function_xi));
    func_xi->parameters = parameters;
    func_xi->func_of_xi = &eqn3_lhs_minus_rhs;

    f_lo = eqn3_lhs_minus_rhs(0,parameters);
    if (f_lo <= 0.0) {
    	printf("Can't bracket the root. Estimate for xi is 0.0!");
    	*xi=0;
    	*sigma_t_sq = current_sigma_t_sq;
    	for (i=1; i<=Ncov; i++) betahat[i] = current_beta[i];;
    } else {
    	brent(func_xi, xi);
    	//*xi=0.449952;
    	f_root = eqn3_lhs_minus_rhs(*xi, parameters);
    	*sigma_t_sq = current_sigma_t_sq;
    	//printf("\ncurrent value is %f.", current_sigma_t_sq);
    	for (i=1; i<=Ncov; i++) betahat[i] = current_beta[i];
    }
    free_dvector(current_beta,1,Ncov);
    free(func_xi);
}


double eqn3_lhs_minus_rhs(double xi, param_func_xi parameters) {
	return target_func_xi(xi, parameters.totpc, parameters.V_f, parameters.S_f,
			parameters.beta_init, parameters.totpc_f, parameters.yaffec_f,
			parameters.Store_cov_f, parameters.Storekin_pc, parameters.current_beta,
			parameters.current_sigma_t_sq, parameters.L);
}


double target_func_xi(double xi, int totpc, double ***V_f, double **S_f, double *beta_init,
		int *totpc_f, double **yaffec_f, double ***Store_cov_f, double ***Storekin_pc,
		double *current_beta, double *current_sigma_t_sq, int L) {

	int i,j,k,l;
	double *betahat;
	double sigma_t_sq;
	double rhs_eq3, lhs_eq3;
    double fvalue;

    double **mu_f;
    mu_f = (double **) malloc ((size_t) ((F+1)*sizeof(double *)));
    mu_f[0]=NULL;

	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {mu_f[i]=NULL;} else {
			mu_f[i] = dvector(1, totpc_f[i]);
		}
	}


	//Sigma_inverse * (Phi - I)
	double ***xi_V1 = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
    xi_V1[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {xi_V1[i]=NULL;} else {
			xi_V1[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
		}
	}
	//Sigma_inverse * (Phi - I) * Sigma_inverse
	double ***xi_V2 = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
    xi_V2[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {xi_V2[i]=NULL;} else {
			xi_V2[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
		}
	}


    //compute Sigma_inv_f;
	double ***Sigma_inv_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
	Sigma_inv_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {Sigma_inv_f[i]=NULL;} else {
			Sigma_inv_f[i] = dmatrix(1, totpc_f[i],1,totpc_f[i]);
		}
	}
	for (i=1; i<=F; i++) {
		if (totpc_f[i]!=0) {
			for (j=1; j<=totpc_f[i];j++) {
				for (k=1; k<=totpc_f[i];k++) {
					Sigma_inv_f[i][j][k]=0.0;
					for (l=1;l<=totpc_f[i];l++) {
						Sigma_inv_f[i][j][k]= Sigma_inv_f[i][j][k] +
								V_f[i][j][l]/(xi*S_f[i][l]+1-xi)*V_f[i][k][l];
					}
				}
			}
		}
	}
	/*		printf("\nNow We check Sigma_inv_f:\n");
				i=26;
				for (j=1; j<=totpc_f[i]; j++) {
					for (k=1; k<=totpc_f[i]; k++) {
						printf("%f ", Sigma_inv_f[i][j][k]);
					}
					printf("\n");
				}*/


	betahat = dvector(1, Ncov);
	int flag_betahat = -1;
	if (L == 2) {
		flag_betahat = compute_gee_betahat(Sigma_inv_f, beta_init, xi, betahat,
				totpc_f, yaffec_f, Store_cov_f, mu_f);
	}
	if (L == 3) {
		flag_betahat = 1;
		compute_linear_mixed_betahat(Sigma_inv_f, xi, betahat,
				totpc_f, yaffec_f, Store_cov_f);
	}

	if (flag_betahat == 0) {
		fvalue = MISSVAL_FUNC_XI;
	} else if (L == 2) {

		//compute mu_f
		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					mu_f[i][j] = 0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += betahat[k] * Store_cov_f[i][j][k];
					}
					    mu_f[i][j] = exp(mu_f[i][j])/(1+exp(mu_f[i][j]));
				}
			}
		}
		//compute sigma_t_sq (total variance)
	    sigma_t_sq=0.0;
	    if (fit_dispersion == 1) {
        for (i=1;i<=F;i++) {
      	  if (totpc_f[i]>0) {
      		  for (j=1;j<=totpc_f[i];j++) {
      			  for (k=1; k<=totpc_f[i];k++) {
      				  sigma_t_sq += (yaffec_f[i][j] - mu_f[i][j])/sqrt(mu_f[i][j]*(1-mu_f[i][j]))*Sigma_inv_f[i][j][k]*(yaffec_f[i][k] - mu_f[i][k])/sqrt(mu_f[i][k]*(1-mu_f[i][k]));
      			  }
      		  }
      	  }
        }
        sigma_t_sq = sigma_t_sq/(totpc);
	    } else {
	    	sigma_t_sq = 1.0;
	    }



		  //compute xi_V1
        for (i=1;i<=F;i++) {
      	  if (totpc_f[i]>0) {
      		  for (j=1;j<=totpc_f[i];j++) {
      			  for (k=1;k<=totpc_f[i];k++) {
      				  xi_V1[i][j][k]=0.0;
      				  for (l=1;l<=totpc_f[i];l++) {
      					  if (l==k) xi_V1[i][j][k] += Sigma_inv_f[i][j][l] * (Storekin_pc[i][l][k]);
      					  else  xi_V1[i][j][k] += Sigma_inv_f[i][j][l] * (2 * Storekin_pc[i][l][k]);
      				  }
      			  }
      		  }
      	  }
        }
        rhs_eq3 = 0.0;
         for (i=1;i<=F;i++) {
       	  if (totpc_f[i]>0) {
       		  for (j=1;j<=totpc_f[i];j++) {
       			  rhs_eq3 += xi_V1[i][j][j];
       		  }
       	  }
         }
      //   printf("\ncheck rhs_eq3: %f.", rhs_eq3);

         //compute xi_V2
         for (i=1;i<=F;i++) {
       	  if (totpc_f[i]>0) {
       		  for (j=1;j<=totpc_f[i];j++) {
       			  for (k=1;k<=totpc_f[i];k++) {
       				  xi_V2[i][j][k]=0.0;
       				  for (l=1;l<=totpc_f[i];l++) {
       					  xi_V2[i][j][k] += xi_V1[i][j][l] *Sigma_inv_f[i][l][k];
       				  }
       			  }
       		  }
       	  }
         }
         //compute lhs_eq3
         lhs_eq3=0.0;
         for (i=1;i<=F;i++) {
       	  if (totpc_f[i]>0) {
       		  for (j=1;j<=totpc_f[i];j++) {
       			  for (k=1;k<=totpc_f[i];k++) {
       				  lhs_eq3 += (yaffec_f[i][j] - mu_f[i][j])/sqrt(mu_f[i][j]*(1-mu_f[i][j])*mu_f[i][k]*(1-mu_f[i][k]))*xi_V2[i][j][k]*(yaffec_f[i][k] - mu_f[i][k]);
       			  }
       		  }
       	  }
         }
         lhs_eq3 = lhs_eq3/sigma_t_sq;
         fvalue = lhs_eq3-rhs_eq3;
	    for (i=1; i<=Ncov; i++) current_beta[i] = betahat[i];
	    *current_sigma_t_sq = sigma_t_sq;


	} else {
		//compute mu_f
		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					mu_f[i][j] = 0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += betahat[k] * Store_cov_f[i][j][k];
					}
				}
			}
		}

	  sigma_t_sq=0.0;
      for (i=1;i<=F;i++) {
    	  if (totpc_f[i]>0) {
    		  for (j=1;j<=totpc_f[i];j++) {
    			  for (k=1; k<=totpc_f[i];k++) {
    				  sigma_t_sq += (yaffec_f[i][j] - mu_f[i][j])*Sigma_inv_f[i][j][k]*(yaffec_f[i][k] - mu_f[i][k]);
    			  }
    		  }
    	  }
      }
      sigma_t_sq = sigma_t_sq/(totpc);
      for (i=1;i<=F;i++) {
    	  if (totpc_f[i]>0) {
    		  for (j=1;j<=totpc_f[i];j++) {
    			  for (k=1;k<=totpc_f[i];k++) {
    				  xi_V1[i][j][k]=0.0;
    				  for (l=1;l<=totpc_f[i];l++) {
    					  if (l==k) xi_V1[i][j][k] += Sigma_inv_f[i][j][l] * (Storekin_pc[i][l][k]);
    					  else  xi_V1[i][j][k] += Sigma_inv_f[i][j][l] * (2 * Storekin_pc[i][l][k]);
    				  }
    			  }
    		  }
    	  }
      }

      rhs_eq3 = 0.0;
      for (i=1;i<=F;i++) {
    	  if (totpc_f[i]>0) {
    		  for (j=1;j<=totpc_f[i];j++) {
    			  rhs_eq3 += xi_V1[i][j][j];
    		  }
    	  }
      }
      //compute xi_V2
       for (i=1;i<=F;i++) {
     	  if (totpc_f[i]>0) {
     		  for (j=1;j<=totpc_f[i];j++) {
     			  for (k=1;k<=totpc_f[i];k++) {
     				  xi_V2[i][j][k]=0.0;
     				  for (l=1;l<=totpc_f[i];l++) {
     					  xi_V2[i][j][k] += xi_V1[i][j][l] *Sigma_inv_f[i][l][k];
     				  }
     			  }
     		  }
     	  }
       }
       //compute lhs_eq3
       lhs_eq3=0.0;
       for (i=1;i<=F;i++) {
     	  if (totpc_f[i]>0) {
     		  for (j=1;j<=totpc_f[i];j++) {
     			  for (k=1;k<=totpc_f[i];k++) {
     				  lhs_eq3 += (yaffec_f[i][j] - mu_f[i][j])*xi_V2[i][j][k]*(yaffec_f[i][k] - mu_f[i][k]);
     			  }
     		  }
     	  }
       }

       lhs_eq3 = lhs_eq3/sigma_t_sq;
       fvalue = lhs_eq3-rhs_eq3;
	   for (i=1; i<=Ncov; i++) current_beta[i] = betahat[i];
	   *current_sigma_t_sq = sigma_t_sq;
	}

	for (i=1; i<=F; i++) {
		if (totpc_f[i]>0) {
			free_dvector(mu_f[i],1, totpc_f[i]);
			free_dmatrix(Sigma_inv_f[i],1, totpc_f[i],1,totpc_f[i]);
			free_dmatrix(xi_V1[i],1, totpc_f[i],1,totpc_f[i]);
			free_dmatrix(xi_V2[i],1, totpc_f[i],1,totpc_f[i]);
		}
	}
	free(mu_f);
	free(Sigma_inv_f);
	free(xi_V1);
	free(xi_V2);
    free_dvector(betahat, 1, Ncov);

	return fvalue;
}

void compute_linear_mixed_betahat(double ***Sigma_inv_f, double xi,
		double *betahat, int *totpc_f, double **yaffec_f, double ***Store_cov_f){
	int i,j,k,l;

    double **inv_XVinverX = dmatrix(1,Ncov,1,Ncov);
    double *XVinverY = dvector(1,Ncov);
    double ***VinverX_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
    VinverX_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {VinverX_f[i]=NULL;} else {
			VinverX_f[i] = dmatrix(1, totpc_f[i],1,Ncov);
		}
	}
	double *a;
	a = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	double *b;
	b = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));

	for (i=1;i<=F;i++) {
		if (totpc_f[i]>0) {
			for (j=1;j<=totpc_f[i];j++) {
				for (k=1;k<=Ncov;k++) {
					VinverX_f[i][j][k] = 0.0;
					for (l=1;l<=totpc_f[i];l++){
						VinverX_f[i][j][k] += Sigma_inv_f[i][j][l]*Store_cov_f[i][l][k];
					}
				}
			}
		}
	}
	for (i=1;i<=Ncov;i++) {
		for (j=1;j<=Ncov;j++) {
			inv_XVinverX[i][j]=0.0;
			for (k=1;k<=F;k++) {
				if (totpc_f[k]>0) {
					for (l=1;l<=totpc_f[k];l++) {
						inv_XVinverX[i][j] += Store_cov_f[k][l][i]*VinverX_f[k][l][j];
					}
				}
			}
		}
	}

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			a[(j - 1) * Ncov + (i - 1)] = inv_XVinverX[i][j];
		}
	}

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			if (i == j)
				b[(j - 1) * Ncov + (i - 1)] = 1;
			else
				b[(j - 1) * Ncov + (i - 1)] = 0;
		}
	}
	int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
	char *uplo = "L";
	dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);

	for (j = 1; j <= Ncov; j++) {
		for (i = 1; i <= Ncov; i++) {
			inv_XVinverX[i][j] = b[(j - 1) * Ncov + (i - 1)];
		}
	}

	for (i=1;i<=Ncov;i++){
		XVinverY[i]=0.0;
		for (j=1;j<=F;j++){
			if (totpc_f[j]>0) {
				for (k=1;k<=totpc_f[j];k++) {
					XVinverY[i] += VinverX_f[j][k][i] * yaffec_f[j][k];
				}
			}
		}
	}
    for(i=1;i<=Ncov;i++) {
    	betahat[i]=0.0;
    	for (j=1;j<=Ncov;j++) {
    		betahat[i] += inv_XVinverX[i][j]*XVinverY[j];
    	}
    }

	for (i=1; i<=F; i++) {
	if (totpc_f[i]>0) {
	free_dmatrix(VinverX_f[i],1, totpc_f[i],1,Ncov);
	}
	}

	free_dmatrix(inv_XVinverX,1,Ncov,1,Ncov);
	free(VinverX_f);
	free_dvector(XVinverY,1,Ncov);
	free(a);
	free(b);

}

int compute_gee_betahat(double ***Sigma_inv_f, double *beta_init, double xi,
		double *betahat, int *totpc_f, double **yaffec_f, double ***Store_cov_f,
		double **mu_f) {
	int i,j,k,l;
	double diff_beta = 1.0;
    // printf("Current xi is: %f.\n",xi);
	int loop_while = 0;
	int flag_while = 1;

	double *betaLold = dvector(1, Ncov);
	double *betaLnew = dvector(1, Ncov);
    double **inv_XVinverX = dmatrix(1,Ncov,1,Ncov);
    double *XVinverY = dvector(1,Ncov);
    double ***VinverX_f = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
    VinverX_f[0] = NULL;
	for (i=1; i<=F; i++) {
		if (totpc_f[i]==0) {VinverX_f[i]=NULL;} else {
			VinverX_f[i] = dmatrix(1, totpc_f[i],1,Ncov);
		}
	}
	double *a;
	a = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	double *b;
	b = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));

	for (i = 1; i <= Ncov; i++) {
		betaLnew[i]=beta_init[i];
		betaLold[i]=beta_init[i];
	}

	while (diff_beta > 10e-9) {

        loop_while++;
        if (loop_while >= 1000) {
        	FILE *optim_error;
        	optim_error = fopen("optim_error.txt","a+");
        	fprintf(optim_error,"While loop in function compute_gee_betahat"
        			" is deadlocked, where xi is %f.\n",xi);
        	fclose(optim_error);
        	flag_while = 0;
        	break;
        }
		for (i = 1; i <= Ncov; i++)
			betaLold[i] = betaLnew[i];
		//compute mu_f
		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					mu_f[i][j] = 0.0;
					for (k=1;k<=Ncov;k++) {
						mu_f[i][j] += betaLold[k] * Store_cov_f[i][j][k];
					}
					mu_f[i][j] = exp(mu_f[i][j])/(1+exp(mu_f[i][j]));
				}
			}
		}
/*		printf("\ncheck mu_f:\n");
		for (i=1; i<=F; i++) {
			if (totpc_f[i]>0) {
				for (j=1; j<=totpc_f[i]; j++) {
					printf("%f ",mu_f[i][j]);
			    }
				printf("\n");
		    }
		}*/
	//	for (k=1;k<=Ncov;k++) {printf("%f ",betaLold[k]); }
		//compute inv_XVinverX
/*						for (j = 1; j <= Ncov; j++) {
							for (k = 1; k <= Ncov; k++) {
								inv_XVinverX[j][k] = 0.0;
								for (i = 1; i <= F; i++) {
									if (totpc_f[i] > 0) {
										for (l = 1; l <= totpc_f[i]; l++) {
											for (m = 1; m <= totpc_f[i]; m++) {
												inv_XVinverX[j][k]
														+= Store_cov_f[i][l][j]
																* Sigma_inv_f[i][l][m]
																* sqrt(mu_f[i][l] * (1
																		- mu_f[i][l]))
																* sqrt(mu_f[i][m] * (1
																		- mu_f[i][m]))
																* Store_cov_f[i][m][k];
											}
										}

									}
								}
							}
						}*/
		for (i=1;i<=F;i++) {
			if (totpc_f[i]>0) {
				for (j=1;j<=totpc_f[i];j++) {
					for (k=1;k<=Ncov;k++) {
						VinverX_f[i][j][k] = 0.0;
						for (l=1;l<=totpc_f[i];l++){
							VinverX_f[i][j][k] += Sigma_inv_f[i][j][l]*Store_cov_f[i][l][k]*sqrt(mu_f[i][l]*(1-mu_f[i][l])*mu_f[i][j]*(1-mu_f[i][j]));
						}
					}
				}
			}
		}

		for (i=1;i<=Ncov;i++) {
			for (j=1;j<=Ncov;j++) {
				inv_XVinverX[i][j]=0.0;
				for (k=1;k<=F;k++) {
					if (totpc_f[k]>0) {
						for (l=1;l<=totpc_f[k];l++) {
							inv_XVinverX[i][j] += Store_cov_f[k][l][i]*VinverX_f[k][l][j];
						}
					}
				}
			}
		}
    //	for (i=1;i<=F;i++) printf("%d ", totpc_f[i]);
/*		printf("\nCheck inv_XVinverX:\n");
		for (i = 1; i <= Ncov; i++) {
			for (j = 1; j <= Ncov; j++) {
				printf("%f ",inv_XVinverX[i][j]);
			}
			printf("\n");
		}*/

		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				a[(j - 1) * Ncov + (i - 1)] = inv_XVinverX[i][j];
			}
		}

		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				if (i == j)
					b[(j - 1) * Ncov + (i - 1)] = 1;
				else
					b[(j - 1) * Ncov + (i - 1)] = 0;
			}
		}
		int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
		char *uplo = "L";
		dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);

		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				inv_XVinverX[i][j] = b[(j - 1) * Ncov + (i - 1)];
			}
		}

/*	 		   printf("\nCheck inv_XVinverX:\n");
		for (i = 1; i <= Ncov; i++) {
			for (j = 1; j <= Ncov; j++) {
				printf("%f ",inv_XVinverX[i][j]);
			}
			printf("\n");
		}*/

		//compute XVinverY
		for (i=1;i<=F;i++) {
			if (totpc_f[i]>0) {
				for (j=1;j<=totpc_f[i];j++) {
					for (k=1;k<=Ncov;k++) {
						VinverX_f[i][j][k] = 0.0;
						for (l=1;l<=totpc_f[i];l++){
							VinverX_f[i][j][k] += Sigma_inv_f[i][j][l]*Store_cov_f[i][l][k]/sqrt(mu_f[i][j]*(1-mu_f[i][j]))*sqrt(mu_f[i][l]*(1-mu_f[i][l]));
						}
					}
				}
			}
		}

		for (i=1;i<=Ncov;i++){
			XVinverY[i]=0.0;
			for (j=1;j<=F;j++){
				if (totpc_f[j]>0) {
					for (k=1;k<=totpc_f[j];k++) {
						XVinverY[i] += VinverX_f[j][k][i] * (yaffec_f[j][k]-mu_f[j][k]);
					}
				}
			}
		}
	//	for (i=1;i<=Ncov;i++){printf("%f ",XVinverY[i]);}


		//solve quasi-likelihood equations for beta using Newton's method with Fisher scoring
		for (i=1; i<=Ncov; i++) {
			for (j=1;j<=Ncov;j++) {
				betaLnew[i] += inv_XVinverX[i][j] * XVinverY[j];
			}
		}
//		printf("\ncheck betaLnew:");
//		for (i=1;i<=Ncov;i++){printf("%f ",betaLnew[i]);}

		//compute beta_diff
		diff_beta=0.0;
		for (i=1; i<=Ncov; i++) diff_beta += fabs(betaLnew[i]-betaLold[i]);
	//	printf("\ndiff_beta is %f.",diff_beta);
 //   printf("Current loop is %d.\n",loop_while);

	}


	for (i=1; i<=Ncov; i++) {
		if ((int)isnan(betaLnew[i])==1) flag_while=0;
	}


	if (flag_while==1) {
		for (i=1; i<=Ncov; i++) betahat[i] = betaLnew[i];
	} else {
		for (i=1; i<=Ncov; i++) betahat[i] = 0.0;
	}

	for (i=1; i<=F; i++) {
	if (totpc_f[i]>0) {
	free_dmatrix(VinverX_f[i],1, totpc_f[i],1,Ncov);
	}
	}


	free_dvector(betaLold, 1, Ncov);
	free_dvector(betaLnew, 1, Ncov);
	free_dmatrix(inv_XVinverX,1,Ncov,1,Ncov);
	free(VinverX_f);
	free_dvector(XVinverY,1,Ncov);
	free(a);
	free(b);
	return flag_while;

}


void compute_logistic_coeff(double *yaffec, int *covflag,
	                        int totpc, double *beta_init) {
	int i,j,k,l;
	//sposv_( char *uplo, int *n, int *nrhs, float *A,
	//int *lda, float *B, int *ldb, int *info );
	int n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
	char *uplo = "L";
	double *a;
	a = dvector(0,Ncov*Ncov);
	double *b;
	b = dvector(0,Ncov*Ncov);

	double* pi;
	pi = dvector(1, totpc);
	for (i = 1; i <= totpc; i++)
		pi[i] = (yaffec[i] + 1.0 / 2.0) / 2.0;
	double* piold;
	piold = dvector(1, totpc);
	for (i = 1; i <= totpc; i++) piold[i]=0.0;
	double* w;
	w = dvector(1, totpc);
	for (i = 1; i <= totpc; i++)
		w[i] = pi[i] * (1 - pi[i]);
	double* z;
	z = dvector(1, totpc);
	for (i = 1; i <= totpc; i++)
		z[i] = (yaffec[i] - pi[i]) / w[i] + log(pi[i] / (1 - pi[i]));
	double** XtWX;
	XtWX = dmatrix(1, Ncov, 1, Ncov);
	double**XtWXinver;
	XtWXinver = dmatrix(1, Ncov, 1, Ncov);
	double* XtWZ;
	XtWZ = dvector(1, Ncov);
	double* betaLold;
	betaLold = dvector(1, Ncov);
	double* betaLnew;
	betaLnew = dvector(1, Ncov);
	double diff = 1.0;
	double diffpi = 1.0;

	while (diffpi > 1e-6) {

		for (i = 1; i <= Ncov; i++)
			betaLold[i] = betaLnew[i];

		for (i = 1; i <= Ncov; i++) {
			for (j = 1; j <= Ncov; j++) {
				XtWX[i][j] = 0;
				for (k = 1; k <= totpc; k++) {
					XtWX[i][j] += StoreCov[k][i] * w[k] * StoreCov[k][j];
				}
			}
		}

     //   printf("\n%f ",XtWX[1][1]);
     //   exit(1);
		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				a[(j - 1) * Ncov + (i - 1)] = XtWX[i][j];
			}
		}

		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				if (i == j)
					b[(j - 1) * Ncov + (i - 1)] = 1;
				else
					b[(j - 1) * Ncov + (i - 1)] = 0;
			}
		}

		n = Ncov, nrhs = Ncov, lda = Ncov, ldb = Ncov;

		dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);

		for (j = 1; j <= Ncov; j++) {
			for (i = 1; i <= Ncov; i++) {
				XtWXinver[i][j] = b[(j - 1) * Ncov + (i - 1)];
			}
		}
    //    printf("\n%f ",XtWXinver[1][1]);
    //    exit(1);
		for (i = 1; i <= Ncov; i++) {
			XtWZ[i] = 0;
			for (j = 1; j <= totpc; j++) {
				XtWZ[i] += StoreCov[j][i] * w[j] * z[j];
			}
		}
    //   printf("\n%f ",XtWZ[1]);
     // exit(1);
		for (i = 1; i <= Ncov; i++) {
			betaLnew[i] = 0;
			for (j = 1; j <= Ncov; j++) {
				betaLnew[i] += XtWXinver[i][j] * XtWZ[j];
			}
		}
		//   printf("\nbetaLnew is:%f ",betaLnew[1]);
			//      exit(1);
		diff = 0.0;
		for (i = 1; i <= Ncov; i++) diff += fabs(betaLnew[i] - betaLold[i]);
		diffpi = 0.0;
		for (i = 1; i <= totpc; i++) diffpi += fabs(pi[i] - piold[i]);
		//printf("diff is:%f %f %f %f.\n",diff,diffpi,betaLnew[2] - betaLold[2],betaLnew[2]);
		if (diffpi<1e-6) {
			for (i = 1; i <= Ncov; i++) betaLnew[i]= betaLold[i];
			if (diff>1e-5) printf("Fail to convergence; fitted probabilities numerically 0 or 1 occurred!\n");
		}
		else {for (i = 1; i <= totpc; i++) {
			piold[i]=pi[i];
			pi[i] = 0;
			for (j = 1; j <= Ncov; j++) {
				pi[i] += StoreCov[i][j] * betaLnew[j];
			}
			pi[i] = exp(pi[i]) / (1 + exp(pi[i]));
		}
		//for (i=1;i<=totpc;i++) printf("%f ",pi[i]);
		//exit(1);
		for (i = 1; i <= totpc; i++)
			w[i] = pi[i] * (1 - pi[i]);
		for (i = 1; i <= totpc; i++)
			z[i] = (yaffec[i] - pi[i]) / w[i] + log(pi[i] / (1 - pi[i]));
		//for (i=1;i<=totpc;i++) printf("%f ",z[i]);
	}
	}

	for (i=1; i<=Ncov; i++) {
		logistic_coeff_var[i] = XtWXinver[i][i];
	}


	for (i = 1; i <= Ncov; i++)
		betaLold[i] = betaLnew[i];
	for (i = 1; i <= Ncov; i++)
		beta_init[i] = betaLnew[i];

	free_dvector(a,0,Ncov*Ncov);
	free_dvector(b,0,Ncov*Ncov);
	free_dvector(pi, 1, totpc);
	free_dvector(piold,1,totpc);
	free_dvector(w, 1, totpc);
	free_dvector(z, 1, totpc);
	free_dmatrix(XtWX, 1, Ncov, 1, Ncov);
	free_dmatrix(XtWXinver, 1, Ncov, 1, Ncov);
	free_dvector(XtWZ, 1, Ncov);
	free_dvector(betaLold, 1, Ncov);
	free_dvector(betaLnew, 1, Ncov);
}
void genotyped_relative_flag(int *geno_info_flag) {
	int i,j,k,l;
	int m=1;
	int totnum=0;
	for (i=1;i<=F;i++) {
		for(j=1;j<=famdata[i].N;j++) {
			geno_info_flag[totnum+j]=0;
			if (Mark[m].mark[i][j][1]!=0 && Mark[m].mark[i][j][2]!=0) {geno_info_flag[totnum+j]=1;} else {
				for(k=1;k<=famdata[i].N;k++) {
					if (Storekin[i][j][k]>0.0 && Mark[m].mark[i][k][1]!=0 && Mark[m].mark[i][k][2]!=0) {geno_info_flag[totnum+j]=1;break;}
			    }
			}
		}

		totnum = totnum + famdata[i].N;
	}
}

//SetR corresponding W1 in the software documentation
void SetR_flag(int *geno_info_flag) {
	int i,j,k,l;
	int m=1;
	int totnum=0;
	int pass;
	for (i=1;i<=F;i++) {
		for(j=1;j<=famdata[i].N;j++) {
			pass = 0;
			geno_info_flag[totnum+j]=0;
			if (Mark[m].mark[i][j][1]!=0 && Mark[m].mark[i][j][2]!=0) {geno_info_flag[totnum+j]=1;continue;} else {
				for(k=1;k<=famdata[i].N;k++) {
					if (Storekin[i][j][k]>0.0 && Mark[m].mark[i][k][1]!=0 && Mark[m].mark[i][k][2]!=0) {geno_info_flag[totnum+j]=1;pass=1;break;}
			    }
			}
			if (pass==1) continue;
			for(k=1;k<=famdata[i].N;k++) {
				if (famdata[i].AFFEC[k][2]>0) {
					if (Mark[m].mark[i][k][1]!=0 && Mark[m].mark[i][k][2]!=0) {geno_info_flag[totnum+j]=1;pass=1;break;}else {
					for (l=1;l<=famdata[i].N;l++) {
						if (Storekin[i][l][k]>0.0 && Mark[m].mark[i][l][1]!=0 && Mark[m].mark[i][l][2]!=0) {geno_info_flag[totnum+j]=1;pass=1;break;}
					}
					}
				}
				if (pass==1) break;
			}
		}

		totnum = totnum + famdata[i].N;
	}
}
