/*
 * MQLSC.h
 *
 *  Created on: Dec 26, 2013
 *      Author: Sheng Zhong
 */

#ifndef CERAMIC_H_
#define CERAMIC_H_


//the maximum number of families allowed in the analysis
#define MAXFAM 10000

//the number of top SNPs to be recorded in the output file
#define MAXTOP 20

//the maximum number of covariates allowed in the analysis
#define MAXCOV 10

#define MAXLEN 1000

//the missing value for covariates
#define MISSINGVAL -9999.0


struct FAM {

	int N; //total number of individuals in a family
	int Pheno; //number of individuals have legal phenotypic values (0=unknown, 1=unaffected, 2=affected)
	int Unknown; // number of individuals with unknown phenotype (= 0)
	int INCORRECTPheno; //number of individuals with illegal phenotypic values

	double **cholent; //used in cholesky decomposition
	double **chol; //used in cholesky decomposition

	int *MissingVec; // list of individuals with missing genotypes
	int *descri; //  array of correspondence between rank in the family and Id's
	double **AVEC; //the "A" vector in MQLS paper
	int **AFFEC; //to record phenotype
	int *SEX; //to record sex
	int *STUDYID; //the order in which individuals appear in the phenotype file
	double **CorrectedAFFEC; //record the affection status after being corrected by covariates and/or polygenic effects
};
typedef struct Nsize {
	int N; //total number of individuals
	int Nc; // number of cases
	int Nt; //number of controls
	int Nu; //number of unknown controls
} Nsize;
struct MARKER {
	int Nball; //number of alleles
	int Nc; //number of cases with known genotype
	int Nt; //number of controls with known genotype
	int Nu; //number of unknown controls with known genotype
	int ***mark; //3-dim array. 1st dimension: family number; 2nd dim: indiv rank; 3rd dim has 3 components [1]:allele1,[2]:allele2 and [3]:status
	Nsize *typed;
};


#endif /* MQLSC_H_ */
