/*
 * CERAMIC.c
 *
 *  Created on: Oct 26, 2011
 *      Author: shengz
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

//Include the following for command line build
#include "global_variables.h"
#include "CERAMIC.h"
#include "read_data.c"
#include "compute_residuals.c"
#include "nrutil.c"
#include "cholesky.c"
#include "chisq.c"
#include "svdcomp.c"
#include "brent.c"
#include "z.c"

//Include the following for Eclipse build
/*
#include "global_variables.h"
#include "read_data.h"
#include "CERAMIC.h"
#include "compute_residuals.h"
*/

//Initialize the external global variables
//The number of alleles
int M = 0;

//Total number of individuals in the study
int N = 0;

//Total number of families
int F = 0;

//Total number of individuals with legal phenotype values
int NPheno = 0;

//Total numbers of individuals affected, unaffected, with unknow phenotype
int Naffected = 0, NUnaffected = 0, NUnknown = 0;

//Total number of individuals with illegal phenotypic value (-9 will be assigned in case)
int NINCORRECTPheno = 0;


FILE *outfile, *genofile, *sigfile, *pvfile;
FILE *phenomodel_estimates_file;

//Pointer to kinship file
FILE *idfile;

//pointer to phenotype file
FILE *famfile;

//pointer to a file recording errors during program's execution
FILE *errfile;

//Store data for an array of families (see struct FAM)
struct FAM famdata[MAXFAM];

//Store data for the current marker being tested
struct MARKER Mark[2];

//Store kinship coefficients
double ***Storekin;

//Maximum length of a line of genotype values for a SNP (= 6 * NPheno)
int MAXLINE;

//A switch that decides whether to use unknown controls or not
int Option = 1;

//A switch that decides whether to use phenotyped individuals with missing genotyes
int Missing = 1;

//X=0 for autosomal chromosomes, X=1 for X chromosome
int X = 0;

//HWE=1 calculates genotypic variance assuming HWE; default is 0.
int HWE = 0;

//The iterator for the number of markers
int BIGMARKER;

//Total number of genotyped individuals for the current SNP
int TYPEDNUM;

//Total number of SNP names in the SNP name file
int NAMECOUNT;

//Pointer to the SNP name file
FILE *fsnpname;

//Estimated heritability using all the individuals with non-missing phenotypes and covariates
double GWAS_heritability = -1.0;

//Number of covariates (including the intercept)
int Ncov = 0;

//Store the Covariates
double **StoreCov;

//Equals 1 if the individual is genotyped at the current SNP
int *genoflag;

//noCov is 1 if there are no covariates.
int noCov = 0;

//genoflagmatrix[i][j]=1 if individual j in family i is genotyped
int **genoflagmatrix;

/*genocovflagmatrix[i][j]=1 if individual j in family i is
 * (1) genotyped given Option=1, i.e., including unknown controls
 * or (2) genotyped and phenotyped given Option=2, i.e. excluding unknown controls
 * This is used in calculating the robust estimator for genotypic variance with covariates.
 */
int **genocovflagmatrix;


//A test feature to print p-values
FILE *FileSimResults;

//The robust estimator for genotypic variance (calculated using covariates)
double *robustvar_cov;

//Start time of the main function
//clock_t lauch;

/* use_cov_geno_var = 1 if we choose to calculate the robust estimator for
 * genotypic variance using covariates.
 */
int use_cov_geno_var = 1;

/* default is 1, 0 means using a slow genofile reader (text files) that perform certain
 * checks, and 2 means using a binary genofile reader (fastest).
 */
int genofile_reader = 1;

//defualt is 0, and fit_dispersion = 1 if we choose to add sigma_T^2.
int fit_dispersion = 0;

//store cholesky decomposition upper triangular matrix for complete date
//scenario (to prevent from repeated computation)
double ***global_chol;
//inverse and transpose of global_chol
double ***global_chol1;
int complete_data = 0;

//indicate whether or not to print results for simulation purpose
int sfile = 0;


char **TOPSNPNAME, **TOPSNPNAME2, **TOPSNPNAME3;
int *TOPPorder, *TOPPorder2, *TOPPorder3;
double *TOPPvalues, *TOPPvalues2, *TOPPvalues3;

double *logistic_coeff_var;

extern void dposv_(char *uplo, int *n, int *nrhs, double *A, int *lda,
		double *B, int *ldb, int *info);
void init_flags();
void init_TOPSNPs(int nfile, char *name);
void print_header();
void getsnpnamefile(char *name);
int getgenoline(struct MARKER *Mark, struct FAM *famdata, FILE *errfile);
void readcov3(double **StoreCov, double *yaffec, int *flag, int *genoflag);
void readcov4(int** genoflagmatrix, int **genocovflagmatrix);
void readGenotypes(int fam, int m, int length, double **cholaug,
		double **cholaugCase, double **cholaugControl, double **cholaugUnknown,
		int *MissingVec, int miss, double **kincoefmatrix,
		double **kincoefMatrixCase, double **kincoefmatrixControl,
		double **kincoefmatrixUnknown);
void computeYRandR1(double **cholaug, double *YRvector, double *R1value,
		int size);
void alleleFreq(double **cholaug, double *frequency, int size,
		double *denominator);
void naiveCount(double **cholaug, double *Naive, double *Naivefreq, int size);
void comput_info_chi2(double **kincoefMatrix, double **cholaug, double *info_rr,
		double *info_rf, double *info_ff, int size);
void robustvar(double **cholaug, double *ROBUST_11, double *YYvector,
		double *Y1vector, int size, int *Nstu);
void getfrequency(double *Naivefreq, double *NaivefreqCase,
		double *NaivefreqControl, double *NaivefreqUnknown, double *frequency,
		double *frequencyCase, double *frequencyControl,
		double *frequencyUnknown, double denominator, double denomcases,
		double denomcontrols, double denomunknown, int Nall, int Ncase,
		int Ncontrol, int Nunknown);
int makeFreqMat(double **freqMatrix, double *frequency);
void from_info2_chi2(double info_rr, double info_rf, double info_ff,
		double R1value, double *Naivefreq, double **freqNaive, double *YRvector,
		int Nall, double *chi2val);
void modifcholaug(double **cholent, double **cholaug, double **chol,
		double *frequency, int size);
void comput_info_scoreMQLS(double **cholaug, double **freqMatrix,
		double *infoQL_rr, double *infoQL_rf, double *infoQL_ff,
		double *Rvector, int size);
void from_info2_score(double **freqMatrix, double infoQL_rr, double infoQL_rf,
		double infoQL_ff, double *Rvector, double *testval);
void from_info2_scoreROBUST(double **freqMatrix, double infoQL_rr,
		double infoQL_rf, double infoQL_ff, double *Rvector, double *testval,
		double ROBUST_11, double *YYvector, double *Y1vector, int Nstu,
		double *ROBUSTVAR);
void from_info2_chi2_ROBUST(double info_rr, double info_rf, double info_ff,
		double R1value, double *Naivefreq, double **freqNaive, double *YRvector,
		int Nall, double *chi2val, double ROBUST_11, double *YYvector,
		double *Y1vector, int Nstu, double *ROBUSTVAR);
void comput_info_score(double **cholaug, double **freqMatrix, double *infoQL_rr,
		double *infoQL_rf, double *infoQL_ff, double *Rvector, int size);
void vecsrt2(double *d, int *M, char **NAME, int n);
double pochisq(double x, int df);
void estimate_genovar_cov();
void handle_MZtwin(int Missing, int Option);
int getgenoline_binary(struct MARKER *Mark, struct FAM *famdata, FILE *errfile);
int getgenoline_fast(struct MARKER *Mark, struct FAM *famdata, FILE *errfile);



int main(int argc, char *argv[]) {
	
	printf("\n"
           "--------------------------------------------------------------------------------\n"
           "|                                  CERAMIC                                     |\n"
           "|             (Mixed-Model Association Analysis of Binary Traits)              |\n"
           "|                         Version 1.0 - October 23, 2016                       |\n"
           "|                                                                              |\n"
           "|                              Copyright(C) 2016                               |\n"
           "|                      Sheng Zhong, Duo Jiang and Mary Sara McPeek             |\n"
           "|                                                                              |\n"
           "|                                 Homepage:                                    |\n"
           "|             http://galton.uchicago.edu/~mcpeek/software/CERAMIC              |\n"
           "--------------------------------------------------------------------------------\n\n"
           );

//	lauch = clock();

	double **cholaug, **cholentCase, **cholentControl, **cholentUnknown;
	double **kincoefMatrix, **kincoefMatrixCase, **kincoefMatrixControl,
			**kincoefMatrixUnknown;
	double *frequency, *frequencyCase, *frequencyControl, *frequencyUnknown;
	double **freqMatrix;
	double testval = 0, chi2val = 0, denominator = 0, denomcases = 0,
			denomcontrols = 0, denomunknown = 0;
	double *Naive, *Naivefreq, **freqNaive, *NaiveCase, *NaiveControl,
			*NaiveUnknown, *NaivefreqCase, *NaivefreqControl, *NaivefreqUnknown,
			*Rvector;
	double info_rr = 0, info_rf = 0, info_ff = 0, infoQL_rr = 0, infoQL_rf = 0,
			infoQL_ff = 0;
	int i, j, k, fam, m, followcase = 0, followcontrol = 0, followunknown,
			followall = 0, df = 0, negfreq = 0;
	double MQLSval = 0, MQLSvalrobust = 0, chi2valrobust = 0, testvalrobust = 0;


	double pval1, pval2, pval3;
	int top;

	double *YYvector, *Y1vector, ROBUST_11, *ROBUSTVAR;
	int Nstu;
	double RW, RM, SBLUE;
	double RCHI;


	//Number of non-polymorphic SNPs (MAF<.0001)
	int nonpolycount = 0;

	char tempname[100];
	char str1[MAXLEN];
	char pedfile[MAXLEN] = "phenofile.txt";
	char kinshipfile[MAXLEN] = "kinfile.txt";
	char samplefile[MAXLEN] = "study.sample";
	char output[MAXLEN] = "output";
	char typedfile[MAXLEN] = "genofile";
	char input[MAXLEN];
	char controlfile[MAXLEN];
	char markerfile[MAXLEN];
	char simfile[MAXLEN];
	char *ch;
	int arg;

	//Indicate whether a file is specified by the user
	int gfile = 0;
	int pfile = 0;
	int ffile = 0;
	sfile = 0;
	int ofile = 0;
	int dfile = 0;
	int cfile = 0;
	int kfile = 0;
	int nfile = 0;

	/* Indicate which method to be used to calculate phenotypic residuals.
	 * Default is 0, residuals based on classic linear regression
	 * 1 -- classic logistic regression
	 * 2 -- logistic mixed
	 * 3 --	linear mixed (MASTOR)
	 */
	int L = 2;
	int only_estimate_phenomodel = 0;
	int flag_fit_GenoVar_intercept = 0;
	/*
	 * Default is 0, which uses the set R in MASTOR paper to calculate
	 * phenotypic residuals; if set to 1, use individuals with missing genotypes,
	 * but have genotyped relatives.
	 */
	int first_degree = 0;

	double *YRvector;
	double R1value = 0;

	/*
	 * ALL=0: calculate phenotypic residuals separately for each SNP
	 * ALL=1: calculate phenotypic residuals once per genome using all
	 * the individuals with non-missing phenotypes and covariates
	 * ALL=2: calculate xi once per genome using all the individuals with
	 * non-missing phenotypes and covariates, but estimate beta and sigma_T^2
	 * separately for each SNP.
	 */
	int ALL = 2;

	if (argc > 1) {
		for (arg = 1; arg < argc && argv[arg][0] == '-'; arg++) {
			switch (argv[arg][1]) {
			case 'p':
				strncpy(pedfile, argv[++arg], MAXLEN);
				printf("User specified phenotype file: %s.\n\n", pedfile);
				pfile = 1;
				break;
			case 'g':
				strncpy(typedfile, argv[++arg], MAXLEN);
				printf("User specified genotype file: %s.\n\n", typedfile);
				gfile = 1;
				break;

			case 'k':
				strncpy(kinshipfile, argv[++arg], MAXLEN);
				printf("User specified pedigree information file: %s.\n\n",
						kinshipfile);
				kfile = 1;
				break;
			case 'n':
				strncpy(markerfile, argv[++arg], MAXLEN);
				printf("user specified SNP names file: %s.\n\n", markerfile);
				nfile = 1;
				break;
			case 'u':
				Option = 2;
				break;
			case 'm':
				Missing = 2;
				break;
			case 'a':
				ALL = 1;
				break;
			case 'x':
				X = 1;
				break;
			case 'h':
				HWE = 1;
				//to keep the structure of the original program
				use_cov_geno_var = 0;
				break;
			case 'L':
				L = 0;
				break;
			case 'G':
				L = 1;
				break;
			case 'M':
				L = 3;
				break;
			case 'f':
				first_degree = 1;
				break;
			//print p-values to a file for simulation purpose
			case 'S':
				strncpy(simfile, argv[++arg], MAXLEN);
				sfile = 1;
				break;
			case 'i':
				use_cov_geno_var = 0;
				flag_fit_GenoVar_intercept = 1;
				break;
			case 'b':
				genofile_reader = 2;
				break;
			case 'r':
				genofile_reader = 0;
				break;
			case 's':
				ALL = 0;
				break;
			case 'D':
				fit_dispersion = 1;
				break;
			case 'c':
				ALL = 1;
				complete_data = 1;
				break;
			case 'N':
				ALL = 1;
				only_estimate_phenomodel = 1;
				break;
			default:
				printf("Unknown option \"%s\"\n", argv[arg]);
				exit(1);

			}
		}

	}

	if (only_estimate_phenomodel == 0) {
		if (genofile_reader == 2) {
			printf("User specified to use binary genotype file.\n\n");
		}
		if (genofile_reader == 0) {
			printf("User specified to use a slow genotype reading function for text genotype files.\n\n");
		}
	}

	if (L == 0) printf("User specified to use phenotypic residuals based on the classic linear regression model.\n\n");
	if (L == 1) printf("User specified to use phenotypic residuals based on the classic logistic regression model.\n\n");
	if (L == 2) printf("User specified to use phenotypic residuals based on the logistic-mixed estimating equation approach.\n\n");
	if (L == 3) printf("User specified to use phenotypic residuals based on the linear mixed-effects model.\n\n");
	if (L == 2 && fit_dispersion == 1) printf("User specified to fit an extra dispersion parameter sigma_T^2.\n\n");

	if (only_estimate_phenomodel == 1) printf("User specified to estimate the phenotypic null model ONLY.\n\n");
	if (only_estimate_phenomodel == 0) printf("User specified to perform GWAS analysis.\n\n");
	if (X == 1) printf("User specified X Chromosome analysis.\n\n");

	if (complete_data == 1) printf("User indicated no missing data. Faster implementation is running.\n(User needed to ensure that data actually"
			"have no missing data, or the program can crash.)\n\n");

	if (complete_data == 1) {
		if (ALL == 0) {
			printf("Two options can not be used together: -c and -S");
			exit(1);
		}
	}

	if (Option == 2) printf("User specified to remove unknown controls from the analysis.\n\n");
	if (ALL == 1 && only_estimate_phenomodel == 0 && complete_data == 0) printf("User specified to estimate phenotypic residuals ONCE for ALL SNPs based on the individuals with nonmissing phenotypes and coavariates.\n\n");
	if (ALL == 2 && only_estimate_phenomodel == 0 && complete_data == 0) printf("User specified to estimate heritability once for all SNPs with the phenotyped\nindividuals with "
			"non-missing covariates.\n\n");

	if (ALL == 1) {
		if (Missing == 2) {
			printf("Two options can not be used together: -a and -m");
			exit(1);
		}
		first_degree = -1;
	}

	if (Missing == 2) printf("User specified to exclude phenotypes of individuals with missing genotypes for the CERAMIC test.\n\n");

	if (first_degree == 1) printf("User specified to use, among the ungenotyped individuals with non-missing phenotypes and covariates, only those having a genotyped relative (the set W2).\n\n");
	if (first_degree == 0) printf("User specified to use the set W1\n\n");

	if (HWE == 1) printf("User specified genotypic variance estimated assuming Hardy-Weinberg equilibrium.\n\n");
	if (HWE == 1 && flag_fit_GenoVar_intercept == 1) {
		printf("Two options can not be used together: -h and -i");
		exit(1);
	}
	if (only_estimate_phenomodel == 0 && use_cov_geno_var == 1) printf("User specified to use covariates to estimate null genotypic variance robustly.\n\n");
	if (flag_fit_GenoVar_intercept == 1) printf("User specified to use covariates to estimate null genotypic variance robustly.\n\n");



	//L>=2: for Logistic-mixed and MASTOR methods
	if (L >= 2 && ALL == 2)
		printf("User specified estimating heritability "
				"once per genome, but total variance and regression coefficients SEPARATELY for each SNP.\n");

	if (!pfile) {
		printf("Phenotype file: %s\n", pedfile);
	}

	if (!gfile && only_estimate_phenomodel == 0) {
		printf("Genotype file: %s\n", typedfile);
	}

	if (!kfile) {
		printf("Pedigree information file: %s\n", kinshipfile);
	}
	if (sfile == 1)
		FileSimResults = fopen(simfile, "a+");



	//Read phenotype file (name: pedfile, pointer: famfile),
	//and calculate N, F, and famdata[i].N
	readFAM(pedfile);

	init_flags();

	// Read phenotype file (name: pedfile, pointer: famfile),
	// and figure out the number of covariates
	readcov1();
	if (Ncov == 0) noCov = 1;

	//Allocate memory to and initiate various fields of famdata
	init_famdata();

	//Read phenotype file (name: pedfile, pointer: famfile),
	//assign values to various fields of famdata
	readdataFAM(famdata, errfile);


	//Set the phenotype to be missing (=0) if an individual has one covariate value
	//missing.
	setphenomissing(famdata);

	//Set the maximum length for a line of genotypes for a SNP
	MAXLINE = NPheno * 6;

	//Allocate memory to Storekin, read kinship file (name: kinshipfile, pointer: idfile),
	//and assign values to Storekin.
	init_storekin();
	readkincoef(kinshipfile, errfile, famdata, Storekin);

	//Allocate memory to and initialize Mark[1]
	init_Mark();

	if (only_estimate_phenomodel == 0) {
	if ((genofile = fopen(typedfile, "r")) == NULL ) {
		printf("Can't open %s\n", typedfile);
		exit(1);
	}
	}
	//allocate memory to and initialize vectors storing information
	//about top SNPs (smallest p-vlues)
	init_TOPSNPs(nfile, markerfile);

	//print header for output files
	if (only_estimate_phenomodel == 0) print_header();
	//an intercept is added
	Ncov = Ncov + 1;

	logistic_coeff_var = dvector(1,Ncov);


/*	clock_t time0;
	time0 = clock();
	double duration_preprocessing = 0.0;
	duration_preprocessing = (double) (time0 - lauch)/CLOCKS_PER_SEC;
*/
	//compute phenotypic residuals using all the individuals with
	//non-missing phenotypes and covariates
	if (ALL == 1) {

		if ((phenomodel_estimates_file = fopen("CERAMICtest.phenoestimates","w")) == NULL) {
			printf("Can't open CERAMICtest.phenoestimates!");
			exit(1);
		}
		fprintf(phenomodel_estimates_file, "User specified to use all phenotyped individuals with non-missing covariates\n"
				"to estimate phenotypic residuals for analysis of ALL SNPs.\nThe following results include the relevant estimates "
				"and their standard errors.\n");

		compute_correctedpheno(L, ALL, first_degree, Missing);
	}

	//User specified to ONLY fit phenotypic null model
	if (only_estimate_phenomodel == 1) {
		fclose(phenomodel_estimates_file);
		exit(0);
	}

	//estimate heritability using all the individuals with
	//non-missing phenotypes and covariates
	if (ALL == 2 && L >= 2) {
		if ((phenomodel_estimates_file = fopen("CERAMICtest.phenoestimates","w")) == NULL) {
			printf("Can't open CERAMICtest.phenoestimates!");
			exit(1);
		}
		fprintf(phenomodel_estimates_file, "User specified to use all phenotyped individuals with non-missing covariates\n"
				"to estimate only heritability xi for analysis of ALL SNPs.\nThe following table gives the relevant estimates "
				"and their standard errors.\nNote that only the estimate for heritability is used in the calculation of the "
				"test statistic. \n");

		GWAS_heritability = estimate_GWAS_heritability(L);

		fprintf(phenomodel_estimates_file,"\nEach of the following tables gives the relevant estimates and their standard "
				"errors for a single SNP.\nNote that the value of heritability is fixed to be the estimate obtained above,\n"
				"and for each SNP, the parameters on covariates (and hence phenotypic residuals) are estimated differently ");
		if (first_degree == 1) fprintf(phenomodel_estimates_file,"using the set W_2 depending the genotype missing pattern for the given SNP (see documentation).\n");
		if (first_degree == 0) fprintf(phenomodel_estimates_file,"using the set W_1 depending the genotype missing pattern for the given SNP (see documentation).\n");

	}
	
	
	if (ALL == 2 && L < 2) {
		if ((phenomodel_estimates_file = fopen("CERAMICtest.phenoestimates","w")) == NULL) {
			printf("Can't open CERAMICtest.phenoestimates!");
			exit(1);
		}
		fprintf(phenomodel_estimates_file, "User specified to calculate phenotypic residuals separately for each SNP.\nEach of the following tables gives the relevant estimates "
				"and their standard\nerrors for a single SNP.\n");
	}
	
	

	if (ALL == 0) {

		if ((phenomodel_estimates_file = fopen("CERAMICtest.phenoestimates","w")) == NULL) {
			printf("Can't open CERAMICtest.phenoestimates!");
			exit(1);
		}
		fprintf(phenomodel_estimates_file, "User specified to calculate phenotypic residuals separately for each SNP.\nEach of the following tables gives the relevant estimates "
				"and their standard\nerrors for a single SNP.\n");
	}

	
	//Flag whether reading a genotype line is successful or not
	int genofile_read_status;

	//Pointer to different genotype reading functions according to user's choice (genofile_reader)
	int (*func_getgeno)(struct MARKER *Mark, struct FAM *famdata, FILE *errfile);
	if (genofile_reader == 0) {
		func_getgeno = &getgenoline;
	} else if (genofile_reader == 1){
		func_getgeno = &getgenoline_fast;
	} else {
		func_getgeno = &getgenoline_binary;
	}

/*	clock_t time1, time2, time3, time4, time5,
	time6, time7, time8, time9, time10;
	clock_t time41, time42, time43, time44;
	clock_t time_before, time_after;
	double duration_getgeno = 0.0;
	double duration_readGenotypes=0.0;
	double duration_phenores = 0.0;
	double duration_genovar_cov = 0.0;
	double duration_getFreq = 0.0;
	double duration_computetests = 0.0;
	double duration_computeXiorPhenoresid = 0.0;
	double duration_whileloop = 0.0;
	double duration_afterwhile = 0.0;

	double duration_readGeno_line = 0.0;
	double duration_computeYRR1 = 0.0;
	double duration_cholesky = 0.0;
	double duration_keyline = 0.0;
	time1 = clock();
	duration_computeXiorPhenoresid = (double) (time1 - time0) / CLOCKS_PER_SEC;
*/
	BIGMARKER = 0;

/*	clock_t time_before1, time_after1;
	double duration_keyline1 = 0.0;
	time_before1 = clock();
*/
	if (complete_data == 1) {

		global_chol = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
		global_chol[0] = NULL;
		for (i=1; i<=F; i++) {
			global_chol[i] = dmatrix(1, famdata[i].N, 1, famdata[i].N);
		}

		global_chol1 = (double ***) malloc ((size_t) ((F+1)*sizeof(double **)));
		global_chol1[0] = NULL;
		for (i=1; i<=F; i++) {
			global_chol1[i] = dmatrix(1, famdata[i].N, 1, famdata[i].N);
		}

		for (i=1; i<=F; i++) {

			double **kinmatrix_temp = dmatrix(1, famdata[i].N, 1, famdata[i].N);
			for (j=1; j<=famdata[i].N; j++) {
				for (k=1; k<=famdata[i].N; k++) {
					if (j==k) {
						kinmatrix_temp[j][k] = 1.0 + Storekin[i][j][k];
					} else {
						kinmatrix_temp[j][k] = 2.0 * Storekin[i][j][k];
					}
				}
			}

			double **aug_temp = dmatrix(1, famdata[i].N, 1, famdata[i].N);
			for (j=1; j<=famdata[i].N; j++) {
				for (k=1; k<=famdata[i].N; k++) {
					if (j==k) {
						aug_temp[j][k] = 1.0;
					} else {
						aug_temp[j][k] = 0.0;
					}
				}
			}

			if (cholesky(kinmatrix_temp, famdata[i].N,
					aug_temp, famdata[i].N, global_chol[i], global_chol1[i],
					1) != 1) {
				printf(
						"Cholesky decomposition of the cov matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
						fam);
				exit(1);
			}

			free_dmatrix(aug_temp, 1, famdata[i].N, 1, famdata[i].N);
			free_dmatrix(kinmatrix_temp, 1, famdata[i].N, 1, famdata[i].N);
		}
	}
//	time_after1 = clock();
//	duration_keyline1 = (double) (time_after1 - time_before1)/CLOCKS_PER_SEC;

//	printf("\nR:\n");
	//Read in a new line of genotypes
	while ((genofile_read_status = func_getgeno(Mark, famdata, errfile)) > 0) {

		BIGMARKER++;
		//if (BIGMARKER > 30) break;
		if (nfile == 1 && BIGMARKER <= NAMECOUNT) {
			fscanf(fsnpname, "%s ", tempname);
		} else {
			sprintf(tempname, "SNP_%d", BIGMARKER);

		}

		if (ALL != 1) fprintf(phenomodel_estimates_file,"\n%d \t %s:", BIGMARKER, tempname);

		m = 1;
		M = Mark[1].Nball;
		robustvar_cov = dvector(1, M);
		for (i = 1; i <= M; i++) robustvar_cov[i] = 0.0;

//		time2 = clock();
//		if (BIGMARKER==1) duration_getgeno = (double) (time2-time1)/CLOCKS_PER_SEC;
//		if (BIGMARKER>1) duration_getgeno += (double) (time2-time6)/CLOCKS_PER_SEC;

		//Estimate genotypic variance using generalized regreesion of genotypes on covariates
		//with kinship matrix as covariance matrix
		if (use_cov_geno_var == 1) {
			estimate_genovar_cov();
		}
//		time10 = clock();

//		duration_genovar_cov += (double) (time10 - time2) / CLOCKS_PER_SEC;

		//Compute phenotypic residuals based on genotype missing pattern for
		//the current SNP
		if (ALL != 1) compute_correctedpheno(L, ALL, first_degree, Missing);

//		time3 = clock();
//		duration_phenores += (double) (time3 - time10) / CLOCKS_PER_SEC;

		//Handle MZ twin in a way described in MQLS paper p. 323
		handle_MZtwin(Missing, Option);

		//Initialize various quantities
		negfreq = 0;
		freqMatrix = dmatrix(1, M, 1, M);
		frequency = dvector(1, M);
		frequencyCase = dvector(1, M);
		frequencyControl = dvector(1, M);
		frequencyUnknown = dvector(1, M);
		Naive = dvector(1, M);
		NaiveCase = dvector(1, M);
		NaiveControl = dvector(1, M);
		NaiveUnknown = dvector(1, M);
		Naivefreq = dvector(1, M);
		Rvector = dvector(1, M);
		NaivefreqCase = dvector(1, M);
		NaivefreqControl = dvector(1, M);
		NaivefreqUnknown = dvector(1, M);
		freqNaive = dmatrix(1, M, 1, M);
		testval = 0;
		chi2val = 0;
		denominator = 0;
		denomcases = 0;
		denomcontrols = 0;
		denomunknown = 0;
		info_rr = 0;
		info_rf = 0;
		info_ff = 0;
		infoQL_rr = 0;
		infoQL_rf = 0;
		infoQL_ff = 0;
		MQLSval = 0;
		ROBUSTVAR = dvector(1, M);
		YYvector = dvector(1, M);
		Y1vector = dvector(1, M);
		YRvector = dvector(1, M);
		ROBUST_11 = 0;
		Nstu = 0;
		R1value = 0;

		for (i = 1; i <= M; i++) {
			frequency[i] = 0;
			frequencyCase[i] = 0;
			frequencyControl[i] = 0;
			frequencyUnknown[i] = 0;
			Naive[i] = 0;
			NaiveCase[i] = 0;
			NaiveControl[i] = 0;
			NaiveUnknown[i] = 0;
			Naivefreq[i] = 0;
			NaivefreqCase[i] = 0;
			NaivefreqControl[i] = 0;
			NaivefreqUnknown[i] = 0;
			if (i < M) {
				Rvector[i] = 0;

				for (j = 1; j <= M - 1; j++) {
					freqMatrix[i][j] = 0;
					freqNaive[i][j] = 0;
				}
			}
		}
		for (i = 1; i <= M; i++)
			Y1vector[i] = 0;
		for (i = 1; i <= M; i++)
			YYvector[i] = 0;
		for (i = 1; i <= M; i++)
			YRvector[i] = 0;

		for (fam = 1; fam <= F; fam++) {

			followall = 0;
			followcase = 0;
			followcontrol = 0;
			followunknown = 0;

			//Set the genotypes of unknown controls to be missing,
			//so that they are dropped from the analysis.
			for (i = 1; i <= famdata[fam].Pheno; i++) {
				if ((Option == 2) && (Mark[1].mark[fam][i][3] == 0)) {
					if (Mark[1].mark[fam][i][1] > 0
							&& Mark[1].mark[fam][i][2] > 0) {
						Mark[1].typed[fam].Nu--;
						Mark[1].Nu--;
						Mark[1].typed[fam].N--;
					}

					Mark[1].mark[fam][i][1] = 0;
					Mark[1].mark[fam][i][2] = 0;
				}
			}

			//Allocate memory to various quantities
			if (Mark[1].typed[fam].N > 0) {
				followall = 1;
				famdata[fam].cholent = dmatrix(1, Mark[1].typed[fam].N, 1,
						M + 3);
				famdata[fam].chol = dmatrix(1, Mark[1].typed[fam].N, 1,
						Mark[1].typed[fam].N);
				cholaug = dmatrix(1, Mark[1].typed[fam].N, 1, M + 3);
				kincoefMatrix = dmatrix(1, Mark[1].typed[fam].N, 1,
						Mark[1].typed[fam].N);
			}
			if ((famdata[fam].Pheno - Mark[1].typed[fam].N) > 0)
				famdata[fam].MissingVec = ivector(1,
						famdata[fam].Pheno - Mark[1].typed[fam].N);

			if (Mark[1].typed[fam].Nc > 0) {
				followcase = 1;
				cholentCase = dmatrix(1, Mark[1].typed[fam].Nc, 1, M + 2);
				kincoefMatrixCase = dmatrix(1, Mark[1].typed[fam].Nc, 1,
						Mark[1].typed[fam].Nc);
			}
			if (Mark[1].typed[fam].Nt > 0) {
				followcontrol = 1;
				cholentControl = dmatrix(1, Mark[1].typed[fam].Nt, 1, M + 2);

				kincoefMatrixControl = dmatrix(1, Mark[1].typed[fam].Nt, 1,
						Mark[1].typed[fam].Nt);
			}
			if (Mark[1].typed[fam].Nu > 0 && Option != 2) {
				followunknown = 1;
				cholentUnknown = dmatrix(1, Mark[1].typed[fam].Nu, 1, M + 2);
				kincoefMatrixUnknown = dmatrix(1, Mark[1].typed[fam].Nu, 1,
						Mark[1].typed[fam].Nu);
			}



			readGenotypes(fam, m, famdata[fam].Pheno, famdata[fam].cholent,
					cholentCase, cholentControl, cholentUnknown,
					famdata[fam].MissingVec,
					famdata[fam].Pheno - Mark[1].typed[fam].N, kincoefMatrix,
					kincoefMatrixCase, kincoefMatrixControl,
					kincoefMatrixUnknown);

//			 time41 = clock();
//			if (fam==1) duration_readGeno_line += (double) (time41-time3)/CLOCKS_PER_SEC;
//			if (fam>1) duration_readGeno_line += (double) (time41-time43)/CLOCKS_PER_SEC;

			//compute YRvector and R1value by adding each family
			computeYRandR1(famdata[fam].cholent, YRvector, &R1value,
					Mark[1].typed[fam].N);

//			time42 = clock();
//			duration_computeYRR1 += (double) (time42-time41)/CLOCKS_PER_SEC;
/*
			//computing allele frequencies in the cases, controls, unknowns...
			if (followcase == 1) {

				naiveCount(cholentCase, NaiveCase, NaivefreqCase,
						Mark[1].typed[fam].Nc);

				if (cholesky(kincoefMatrixCase, Mark[1].typed[fam].Nc,
						cholentCase, M + 1, kincoefMatrixCase, cholentCase, 1)
						!= 1) {
					printf(
							"cholesky decomposition of the case cov matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
							fam);
					exit(1);
				}
				alleleFreq(cholentCase, frequencyCase, Mark[1].typed[fam].Nc,
						&denomcases);
			}

			if (followcontrol == 1) {

				naiveCount(cholentControl, NaiveControl, NaivefreqControl,
						Mark[1].typed[fam].Nt);
				if (cholesky(kincoefMatrixControl, Mark[1].typed[fam].Nt,
						cholentControl, M + 1, kincoefMatrixControl,
						cholentControl, 1) != 1) {
					printf(
							"cholesky decomposition of the control cov matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
							fam);
					exit(1);
				}

				alleleFreq(cholentControl, frequencyControl,
						Mark[1].typed[fam].Nt, &denomcontrols);
			}

			if (followunknown == 1) {

				naiveCount(cholentUnknown, NaiveUnknown, NaivefreqUnknown,
						Mark[1].typed[fam].Nu);
				if (cholesky(kincoefMatrixUnknown, Mark[1].typed[fam].Nu,
						cholentUnknown, M + 1, kincoefMatrixUnknown,
						cholentUnknown, 1) != 1) {
					printf(
							"cholesky decomposition of the unknown phenotyped cov matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
							fam);
					exit(1);
				}

				alleleFreq(cholentUnknown, frequencyUnknown,
						Mark[1].typed[fam].Nu, &denomunknown);
			}
*/
			//computing overall allele frequencies
			if (followall == 1) {


				naiveCount(famdata[fam].cholent, Naive, Naivefreq,
						Mark[1].typed[fam].N);

				comput_info_chi2(kincoefMatrix, famdata[fam].cholent, &info_rr,
						&info_rf, &info_ff, Mark[1].typed[fam].N);
//				time_before = clock();
				if (complete_data == 0) {
				if (cholesky(kincoefMatrix, Mark[1].typed[fam].N,
						famdata[fam].cholent, M + 2, famdata[fam].chol, cholaug,
						1) != 1) {
					printf(
							"Cholesky decomposition of the cov matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
							fam);
					exit(1);
				}
				} else {

					for (i=1; i<=Mark[1].typed[fam].N; i++) {
						for (j=1; j<i; j++) {
							famdata[fam].chol[i][j] = 0.0;
						}
						for (j=i; j<=Mark[1].typed[fam].N; j++) {
							famdata[fam].chol[i][j] = global_chol[fam][i][j];
						}

					}
					for (i=1; i<=Mark[1].typed[fam].N; i++) {
						for (j=1; j<=(M+2); j++) {
							cholaug[i][j] = 0.0;
							for (k=1; k<=i; k++) {
								cholaug[i][j] += global_chol1[fam][i][k] * famdata[fam].cholent[k][j];
							}
						}
					}

				}
//				time_after = clock();
//				duration_keyline += (double)(time_after-time_before)/CLOCKS_PER_SEC;


				alleleFreq(cholaug, frequency, Mark[1].typed[fam].N,
						&denominator);
				if (HWE == 0) {
					robustvar(cholaug, &ROBUST_11, YYvector, Y1vector,
							Mark[1].typed[fam].N, &Nstu);
				}
			}


			if (followall == 1) {
				free_dmatrix(cholaug, 1, Mark[1].typed[fam].N, 1, M + 2);
				free_dmatrix(kincoefMatrix, 1, Mark[1].typed[fam].N, 1,
						Mark[1].typed[fam].N);
				cholaug = NULL;
				kincoefMatrix = NULL;
			}

			if (followcase == 1) {
				free_dmatrix(cholentCase, 1, Mark[1].typed[fam].Nc, 1, M + 1);
				free_dmatrix(kincoefMatrixCase, 1, Mark[1].typed[fam].Nc, 1,
						Mark[1].typed[fam].Nc);
				kincoefMatrixCase = NULL;
				cholentCase = NULL;
			}
			if (followcontrol == 1) {
				free_dmatrix(kincoefMatrixControl, 1, Mark[1].typed[fam].Nt, 1,
						Mark[1].typed[fam].Nt);
				free_dmatrix(cholentControl, 1, Mark[1].typed[fam].Nt, 1,
						M + 1);
				kincoefMatrixControl = NULL;
				cholentControl = NULL;
			}

			if (followunknown == 1) {
				free_dmatrix(kincoefMatrixUnknown, 1, Mark[1].typed[fam].Nu, 1,
						Mark[1].typed[fam].Nu);
				free_dmatrix(cholentUnknown, 1, Mark[1].typed[fam].Nu, 1,
						M + 1);
				kincoefMatrixUnknown = NULL;
				cholentUnknown = NULL;

			}

//		time43 = clock();
//		duration_cholesky += (double) (time43-time42)/CLOCKS_PER_SEC;
		}

//		time4 = clock();
//		duration_readGenotypes += (double) (time4-time3)/CLOCKS_PER_SEC;


		getfrequency(Naivefreq, NaivefreqCase, NaivefreqControl,
				NaivefreqUnknown, frequency, frequencyCase, frequencyControl,
				frequencyUnknown, denominator, denomcases, denomcontrols,
				denomunknown, Mark[1].Nc + Mark[1].Nt + Mark[1].Nu, Mark[1].Nc,
				Mark[1].Nt, Mark[1].Nu);

		makeFreqMat(freqNaive, Naivefreq);


		/* Remove the below comment to calculate the orignial Corrected chi-squared that assumes HWE in the variance calculation  */
		if (HWE == 1) {

			if (Option == 1) {
				from_info2_chi2(info_rr, info_rf, info_ff, R1value, Naivefreq,
						freqNaive, YRvector,
						Mark[1].Nc + Mark[1].Nu + Mark[1].Nt, &chi2val);
			}

			if (Option == 2) {
				from_info2_chi2(info_rr, info_rf, info_ff, R1value, Naivefreq,
						freqNaive, YRvector, Mark[1].Nc + Mark[1].Nt, &chi2val);
			}
		}
		if (makeFreqMat(freqMatrix, frequency) == 1) {
			negfreq = 1;
		}

		if (negfreq == 0) {

			for (fam = 1; fam <= F; fam++) {

				if (Mark[1].typed[fam].N > 0) {
					cholaug = dmatrix(1, Mark[1].typed[fam].N, 1, M + 3);
					modifcholaug(famdata[fam].cholent, cholaug,
							famdata[fam].chol, frequency, Mark[1].typed[fam].N);
					comput_info_scoreMQLS(cholaug, freqMatrix, &infoQL_rr,
							&infoQL_rf, &infoQL_ff, Rvector,
							Mark[1].typed[fam].N);

					free_dmatrix(cholaug, 1, Mark[1].typed[fam].N, 1, M + 3);
				}

			}

			if (HWE == 1) {
				from_info2_score(freqMatrix, infoQL_rr, infoQL_rf, infoQL_ff,
						Rvector, &MQLSval);
			}

			if (HWE == 0) {
				from_info2_scoreROBUST(freqMatrix, infoQL_rr, infoQL_rf,
						infoQL_ff, Rvector, &MQLSvalrobust, ROBUST_11, YYvector,
						Y1vector, Nstu, ROBUSTVAR);

				if (Option == 1) {
					from_info2_chi2_ROBUST(info_rr, info_rf, info_ff, R1value,
							Naivefreq, freqNaive, YRvector,
							Mark[1].Nc + Mark[1].Nt + Mark[1].Nu,
							&chi2valrobust, ROBUST_11, YYvector, Y1vector, Nstu,
							ROBUSTVAR);
				}

				if (Option == 2) {
					from_info2_chi2_ROBUST(info_rr, info_rf, info_ff, R1value,
							Naivefreq, freqNaive, YRvector,
							Mark[1].Nc + Mark[1].Nt, &chi2valrobust, ROBUST_11,
							YYvector, Y1vector, Nstu, ROBUSTVAR);
				}

			}

		}

		// printf("\nYYvector[1]=%f,Y1vector[1]=%f,Nstu=%d,ROBUST_11=%f",YYvector[1],Y1vector[1],Nstu,ROBUST_11);
		// printf("\ninfoQL_rr=%f, infoQL_rf=%f,infoQL_ff=%f Rvector[1]=%f MQLSvalrobust=%f ROBUSTVAR[1]= %f",infoQL_rr,infoQL_rf,infoQL_ff,Rvector[1],MQLSvalrobust,ROBUSTVAR[1]);


//		time5 = clock();
//		duration_getFreq +=(double)(time5-time4)/CLOCKS_PER_SEC;

		/*output printing ... */

		fprintf(outfile, "****************************************");
		fprintf(outfile, "\n\nAnalysis of Marker %d: %s \n\n", BIGMARKER,
				tempname);
		fprintf(outfile, "****************************************\n");

		if (Option == 1) {
			fprintf(outfile,
					"There are %d affected individuals, %d unaffected individuals, and %d individuals of unknown phenotype available. \n\n",
					Mark[1].Nc, Mark[1].Nt, Mark[1].Nu);
		}

		if (Option == 2) {
			fprintf(outfile,
					"%d affected individuals and %d unaffected individuals available.\n\n",
					Mark[1].Nc, Mark[1].Nt);
		}

		fprintf(outfile, "*****************************************\n");
		pval1 = 1;
		pval2 = 1;
		pval3 = 1;

		if ((Mark[1].Nt != 0 || Mark[1].Nu != 0) && Mark[1].Nc != 0
				&& Naivefreq[1] >= .01 && Naivefreq[1] <= .99) {
			df = 0;
			for (i = 1; i <= M - 1; i++)
				if (frequency[i] != 0)
					df++;
			//////////////////////////TESTING CODE STARTS//////////////////////////////////

			//////////////////////////TESTING CODE ENDS////////////////////////////////////

			/******* MQLS and XM TESTS  ************/

			if (X == 0) {
				if (HWE == 0) {
					fprintf(outfile,
							"CERAMIC test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"CERAMIC test using HWE variance estimator\n\n");

			}

			else {
				if (HWE == 0) {
					fprintf(outfile,
							"XM test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"XM test using HWE variance estimator\n\n");

			}

			if (Naivefreq[1] > 0 && Naivefreq[1] < 1) {

				/*	fprintf(outfile,"RM statistic value = %f\t pvalue = %g  df = %d\n\n",RM,pochisq(RM,df),df);  */

				if (HWE == 1) {
					if (X == 0) {
						fprintf(outfile,
								"CERAMIC statistic value = %f\t pvalue = %g  df = %d\n\n",
								MQLSval, pochisq(MQLSval, df), df);
					} else {
						fprintf(outfile,
								"CERAMICX statistic value = %f\t pvalue = %g  df = %d\n\n",
								MQLSval, pochisq(MQLSval, df), df);
					}

					RM = MQLSval;

				}

				if (HWE == 0) {
					if (X == 0) {

						if (sfile == 1)
							fprintf(FileSimResults, "%f ",
									pochisq(MQLSvalrobust, df));

						//   printf("p_MQLSC=%f ",MQLSvalrobust);
						//	printf("Naivefreq is %f.",Naivefreq[1]);
						//	exit(1);
						fprintf(outfile,
								"CERAMIC statistic value = %f\t pvalue =%g  df = %d \n\n",
								MQLSvalrobust, pochisq(MQLSvalrobust, df), df);

					} else {
						fprintf(outfile,
								"CERAMICX statistic value = %f\t pvalue = %e  df = %d\n\n",
								MQLSvalrobust, pochisq(MQLSvalrobust, df), df);
					}
					RM = MQLSvalrobust;
				}
				pval1 = pochisq(RM, df);

				if (pochisq(RM, df) <= 0.05) {

					if (SBLUE > 0)
						fprintf(outfile,
								"Frequency of allele %d is increased in the cases (quasi-score associated to this allele is %.4f)\n\n",
								1, SBLUE);
					if (SBLUE < 0)
						fprintf(outfile,
								"Frequency of allele %d is increased in the controls (quasi-score associated to this allele is %.4f)\n\n",
								1, SBLUE);
					if (SBLUE == 0)
						fprintf(outfile,
								"Frequency of allele %d is the same in cases and controls (quasi-score associated to this allele is 0)\n\n",
								1);

				}

				for (i = 1; i <= M; i++) {
					if (((Mark[1].Nc) * frequencyCase[i]) < 5)
						fprintf(outfile,
								"The p-value might not be exact because of the small number of type %d alleles in cases\n",
								i);

					if (Option == 2) {
						if (((Mark[1].Nt) * frequencyControl[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

					if (Option == 1) {
						if (((Mark[1].Nt) * frequencyControl[i]
								+ (Mark[1].Nu) * frequencyUnknown[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

				}

			} else
				printf("Computation of the CERAMIC statistic is not possible\n\n");

			/********  Corrected Chi-Squared and X-Chi TESTS ************/

			df = 0;
			for (i = 1; i <= M - 1; i++)
				if (frequency[i] != 0)
					df++;
			fprintf(outfile, "\n*****************************************\n");
			/*    fprintf(outfile,"RCHI test \n\n"); */

			if (X == 0) {
				if (HWE == 0) {
					fprintf(outfile,
							"Corrected chi-squared test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"Corrected chi-squared test using HWE variance estimator\n\n");

			}

			else {
				if (HWE == 0) {
					fprintf(outfile,
							"XCHI test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"XCHI  test using HWE variance estimator\n\n");

			}

			if (Naivefreq[1] > 0 && Naivefreq[1] < 1) {
				/*   fprintf(outfile,"RCHI statistic value = %f\t pvalue = %g  df = %d\n\n",RCHI,pochisq(RCHI,df),df);  */

				if (HWE == 1) {
					if (X == 0) {
						fprintf(outfile,
								"Corrected chi-squared statistic value = %f\t pvalue = %g  df = %d \n\n",
								chi2val, pochisq(chi2val, df), df);
					} else {
						fprintf(outfile,
								"XCHI statistic value = %f\t pvalue = %g  df = %d \n\n",
								chi2val, pochisq(chi2val, df), df);
					}

					RCHI = chi2val;
				}

				if (HWE == 0) {
					if (X == 0) {
						fprintf(outfile,
								"Corrected chi-squared statistic value = %f\t pvalue = %g  df = %d \n\n",
								chi2valrobust, pochisq(chi2valrobust, df), df);
					} else {
						fprintf(outfile,
								"XCHI statistic value = %f\t pvalue = %g  df = %d \n\n",
								chi2valrobust, pochisq(chi2valrobust, df), df);
					}
					RCHI = chi2valrobust;
				}
				if (sfile == 1)
					fprintf(FileSimResults, "%f ", pochisq(chi2valrobust, df));
				//	printf("p_CCHIC=%f ",pochisq(chi2valrobust, df));
				pval2 = pochisq(RCHI, df);

				for (i = 1; i <= M; i++) {
					if (((Mark[1].Nc) * NaivefreqCase[i]) < 5)
						fprintf(outfile,
								"The p-value might not be exact because of the small number of allele %d in cases\n\n",
								i);

					if (Option == 2) {
						if (((Mark[1].Nt) * NaivefreqControl[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

					if (Option == 1) {
						if (((Mark[1].Nt) * NaivefreqControl[i]
								+ (Mark[1].Nu) * NaivefreqUnknown[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

					if (((Mark[1].Nt) * NaivefreqControl[i]) < 5)
						fprintf(outfile,
								"The p-value might not be exact because of the small number of allele %d in controls\ni\n",
								i);

				}

			}

			else
				printf(
						"Computation of the Corrected chi-squared statistic is not possible\n\n");

			/********* WQLS and XW TESTS *********/

			info_rr = 0;
			info_rf = 0;
			info_ff = 0;
			infoQL_rr = 0;
			infoQL_rf = 0;
			infoQL_ff = 0;
			testval = 0;
			for (j = 1; j <= M; j++) {
				Rvector[j] = 0;
			}

			for (fam = 1; fam <= F; fam++) {

				if (Mark[1].typed[fam].N > 0) {
					cholaug = dmatrix(1, Mark[1].typed[fam].N, 1, M + 3);
					modifcholaug(famdata[fam].cholent, cholaug,
							famdata[fam].chol, frequency, Mark[1].typed[fam].N);
					comput_info_score(cholaug, freqMatrix, &infoQL_rr,
							&infoQL_rf, &infoQL_ff, Rvector,
							Mark[1].typed[fam].N);
					free_dmatrix(cholaug, 1, Mark[1].typed[fam].N, 1, M + 3);
				}

			}

			/* Remove the below comment to calculate the orignal WQLS that assumes HWE in the variance calculation */

			if (HWE == 1) {
				from_info2_score(freqMatrix, infoQL_rr, infoQL_rf, infoQL_ff,
						Rvector, &testval);
			}

			if (HWE == 0) {
				from_info2_scoreROBUST(freqMatrix, infoQL_rr, infoQL_rf,
						infoQL_ff, Rvector, &testvalrobust, ROBUST_11, YYvector,
						Y1vector, Nstu, ROBUSTVAR);
			}

			df = 0;
			for (i = 1; i <= M - 1; i++)
				if (frequency[i] != 0)
					df++;

			fprintf(outfile, "*****************************************\n");

			if (X == 0) {
				if (HWE == 0) {
					fprintf(outfile,
							"WQLS test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"WQLS test using HWE variance estimator\n\n");

			}

			else {
				if (HWE == 0) {
					fprintf(outfile,
							"XW test using robust variance estimator\n\n");
				}
				if (HWE == 1)
					fprintf(outfile,
							"XW test using HWE variance estimator\n\n");

			}

			if (Naivefreq[1] > 0 && Naivefreq[1] < 1) {
				/* fprintf(outfile,"RW statistic value = %f\t pvalue = %g  df = %d\n\n",RW,pochisq(RW,df),df); */

				if (HWE == 1) {
					if (X == 0) {
						fprintf(outfile,
								"WQLS statistic value = %f\t pvalue = %g  df = %d\n\n",
								testval, pochisq(testval, df), df);
					} else {
						fprintf(outfile,
								"XW statistic value = %f\t pvalue = %g  df = %d\n\n",
								testval, pochisq(testval, df), df);
					}

					RW = testval;

				}

				if (HWE == 0) {
					if (X == 0) {
						fprintf(outfile,
								"WQLS statistic value = %f\t pvalue = %g  df = %d\n\n",
								testvalrobust, pochisq(testvalrobust, df), df);
					} else {
						fprintf(outfile,
								"XM statistic value = %f\t pvalue = %g  df = %d\n\n",
								testvalrobust, pochisq(testvalrobust, df), df);
					}
					RW = testvalrobust;
				}

				if (sfile == 1)
					fprintf(FileSimResults, "%f ", pochisq(testvalrobust, df));
				//	printf("p_WQLSC=%f ",pochisq(testvalrobust, df));
				if (sfile == 1) {
					fprintf(FileSimResults, "\n");
				}

				pval3 = pochisq(RW, df);

				if (pochisq(RW, df) <= 0.05) {

					if (SBLUE > 0)
						fprintf(outfile,
								"Frequency of allele %d is increased in the cases (quasi-score associated to this allele is %.4f)\n\n",
								1, SBLUE);
					if (SBLUE < 0)
						fprintf(outfile,
								"Frequency of allele %d is increased in the controls (quasi-score associated to this allele is %.4f)\n\n",
								1, SBLUE);
					if (SBLUE == 0)
						fprintf(outfile,
								"Frequency of allele %d is the same in cases and controls (quasi-score associated to this allele is 0)\n\n",
								1);

				}

				for (i = 1; i <= M; i++) {
					if (((Mark[1].Nc) * frequencyCase[i]) < 5)
						fprintf(outfile,
								"The p-value might not be exact because of the small number of type %d alleles in cases\n",
								i);

					if (Option == 2) {
						if (((Mark[1].Nt) * frequencyControl[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

					if (Option == 1) {
						if (((Mark[1].Nt) * frequencyControl[i]
								+ (Mark[1].Nu) * frequencyUnknown[i]) < 5)
							fprintf(outfile,
									"The p-value might not be exact because of the small number of type %d alleles in controls\n",
									i);
					}

				}

			} else
				printf("Computation of the RW statistic is not possible\n\n");

		} else {
			//printf("Naivefreq[1] is %f. We have got here!!!!",Naivefreq[1]);

			if ((Mark[1].Nc) == 0)
				fprintf(outfile,
						"\n\nTest statistics are not computed because there are no genotyped cases in the sample for this SNP\n\n");
			else if ((Mark[1].Nt) == 0 && (Mark[1].Nu) == 0)
				fprintf(outfile,
						"\n\nTest statistics are not computed because there are no genotyped controls in the sample for this SNP\n\n");
			else {
				nonpolycount++;
				fprintf(outfile,
						"\n\n Test statistics are not computed because the SNP is not polymorphic: minor allele frequency is less than .0001 \n\n");
			}


			if (sfile == 1) fprintf(FileSimResults, "1 1 1 \n");

		}

		for (fam = 1; fam <= F; fam++) {

			if (Mark[1].typed[fam].N > 0) {
				free_dmatrix(famdata[fam].cholent, 1, Mark[1].typed[fam].N, 1,
						M + 3);
				free_dmatrix(famdata[fam].chol, 1, Mark[1].typed[fam].N, 1,
						Mark[1].typed[fam].N);

			}
			if ((famdata[fam].Pheno - Mark[1].typed[fam].N) > 0)
				free_ivector(famdata[fam].MissingVec, 1,
						famdata[fam].Pheno - Mark[1].typed[fam].N);
		}

		fprintf(outfile, "\n*****************************************\n");
		if (negfreq == 0) {

			if (Option == 2)

			{

				if (frequencyCase[1] == 0 && frequencyCase[2] == 0) {
					denomcases = 1;
				}

				if (frequencyControl[1] == 0 && frequencyControl[2] == 0) {
					denomcontrols = 1;
				}

				fprintf(outfile,
						"allele frequency estimates using the Best Linear Unbiased Estimator (BLUE) in \n");

				fprintf(outfile,
						"\t\t cases\t\t\t unaffected controls \t\t\t all sample \n");
				for (i = 1; i <= M; i++)
					fprintf(outfile,
							"allele %d : freq = %.4f  sd = %.4f\t freq = %.4f  sd = %.4f\t\t freq = %.4f  sd = %.4f\n",
							i, frequencyCase[i],
							sqrt(
									2 * frequencyCase[i]
											* (1 - frequencyCase[i])
											/ denomcases), frequencyControl[i],
							sqrt(
									2 * frequencyControl[i]
											* (1 - frequencyControl[i])
											/ denomcontrols), frequency[i],
							sqrt(
									2 * frequency[i] * (1 - frequency[i])
											/ denominator));
			}

			if (Option != 2) {
				if (frequencyCase[1] == 0 && frequencyCase[2] == 0) {
					denomcases = 1;
				}
				if (frequencyControl[1] == 0 && frequencyControl[2] == 0) {
					denomcontrols = 1;
				}
				if (frequencyUnknown[1] == 0 && frequencyUnknown[2] == 0) {
					denomunknown = 1;
				}

				fprintf(outfile,
						"allele frequency estimates using the Best Linear Unbiased Estimator (BLUE) in \n");

				fprintf(outfile,
						"\t\t\t cases \t\t unaffected controls \t\t unknown controls \t\t all sample \n");
				for (i = 1; i <= M; i++)
					fprintf(outfile,
							"allele %d : freq = %.4f  sd = %.4f \t freq = %.4f  sd = %.4f \t freq = %.4f  sd = %.4f  \t freq = %.4f  sd = %.4f\n",
							i, frequencyCase[i],
							sqrt(
									2 * frequencyCase[i]
											* (1 - frequencyCase[i])
											/ denomcases), frequencyControl[i],
							sqrt(
									2 * frequencyControl[i]
											* (1 - frequencyControl[i])
											/ denomcontrols),
							frequencyUnknown[i],
							sqrt(
									2 * frequencyUnknown[i]
											* (1 - frequencyUnknown[i])
											/ denomunknown), frequency[i],
							sqrt(
									2 * frequency[i] * (1 - frequency[i])
											/ denominator));

			}

		}

		else
			fprintf(outfile,
					"QL computation of allele frequencies gives negative values....\n\nskipped... \n\nUse naive estimates\n\n");

		fprintf(outfile, "*****************************************\n");

		if (Option == 2) {
			fprintf(outfile,
					"allele frequency estimates using naive counting in\n");
			fprintf(outfile,
					"\t\t cases \t\t   unaffected controls \t\t all sample \n");
			for (i = 1; i <= M; i++)
				fprintf(outfile,
						"allele %d : freq = %.4f \t\t freq = %.4f \t\t freq = %.4f\n",
						i, NaivefreqCase[i], NaivefreqControl[i], Naivefreq[i]);
			fprintf(outfile, "*****************************************\n");
		}

		if (Option != 2) {
			fprintf(outfile,
					"allele frequency estimates using naive counting in\n");
			fprintf(outfile,
					"\t\tcases \t\t   unaffected controls \t\tunknown controls \t all sample \n");
			for (i = 1; i <= M; i++)
				fprintf(outfile,
						"allele %d : freq = %.4f \t\t freq = %.4f \t\t freq = %.4f \t\t freq = %.4f\n",
						i, NaivefreqCase[i], NaivefreqControl[i],
						NaivefreqUnknown[i], Naivefreq[i]);
			fprintf(outfile, "*****************************************\n");
		}

		//printf("%d \t %s \t %g \t %g \t %g ", BIGMARKER, tempname, pval1,
				//pval2, pval3);
//		printf("%d \t %s \t %g ", BIGMARKER, tempname, pval1);
		fprintf(outfile, "\n\n\n\n");
//		printf("\tROBUSTVAR is:");
//		printf("%f, ", ROBUSTVAR[1]);
//		printf("robustvar_cov:");
//		printf("%f.", robustvar_cov[1]);
//		printf("\n");
		free_dmatrix(freqMatrix, 1, M, 1, M);
		free_dvector(frequency, 1, M);
		free_dvector(frequencyCase, 1, M);
		free_dvector(frequencyControl, 1, M);
		free_dvector(frequencyUnknown, 1, M);
		free_dvector(Naive, 1, M);
		free_dvector(NaiveCase, 1, M);
		free_dvector(NaiveControl, 1, M);
		free_dvector(NaiveUnknown, 1, M);
		free_dvector(Naivefreq, 1, M);
		free_dvector(Rvector, 1, M);
		free_dvector(NaivefreqCase, 1, M);
		free_dvector(NaivefreqControl, 1, M);
		free_dvector(NaivefreqUnknown, 1, M);
		free_dmatrix(freqNaive, 1, M, 1, M);
		free_dvector(robustvar_cov, 1, M);
		free_dvector(ROBUSTVAR, 1, M);
		free_dvector(YYvector, 1, M);
		free_dvector(Y1vector, 1, M);
		free_dvector(YRvector, 1, M);

		//fprintf(pvfile, "%d \t %s   \t %g \t %g \t %g \n", BIGMARKER, tempname,
	//			pval1, pval2, pval3);
		fprintf(pvfile, "%d \t %s \t %g \n", BIGMARKER, tempname, pval1);
		if (BIGMARKER == 1) {
			TOPPvalues[BIGMARKER] = pval1;
			TOPPorder[BIGMARKER] = BIGMARKER;
			strncpy(TOPSNPNAME[BIGMARKER], tempname, 100);

			TOPPvalues2[BIGMARKER] = pval2;
			TOPPorder2[BIGMARKER] = BIGMARKER;
			strncpy(TOPSNPNAME2[BIGMARKER], tempname, 100);

			TOPPvalues3[BIGMARKER] = pval3;
			TOPPorder3[BIGMARKER] = BIGMARKER;
			strncpy(TOPSNPNAME3[BIGMARKER], tempname, 100);

		} else {
			if (BIGMARKER <= MAXTOP) {

				TOPPvalues[BIGMARKER] = pval1;
				TOPPorder[BIGMARKER] = BIGMARKER;
				strncpy(TOPSNPNAME[BIGMARKER], tempname, 100);

				vecsrt2(TOPPvalues, TOPPorder, TOPSNPNAME, BIGMARKER);

				TOPPvalues2[BIGMARKER] = pval2;
				TOPPorder2[BIGMARKER] = BIGMARKER;
				strncpy(TOPSNPNAME2[BIGMARKER], tempname, 100);

				vecsrt2(TOPPvalues2, TOPPorder2, TOPSNPNAME2, BIGMARKER);

				TOPPvalues3[BIGMARKER] = pval3;
				TOPPorder3[BIGMARKER] = BIGMARKER;
				strncpy(TOPSNPNAME3[BIGMARKER], tempname, 100);

				vecsrt2(TOPPvalues3, TOPPorder3, TOPSNPNAME3, BIGMARKER);

			} else {
				if (pval1 < TOPPvalues[MAXTOP]) {
					TOPPvalues[MAXTOP] = pval1;
					TOPPorder[MAXTOP] = BIGMARKER;
					strncpy(TOPSNPNAME[MAXTOP], tempname, 100);

					vecsrt2(TOPPvalues, TOPPorder, TOPSNPNAME, MAXTOP);

				}

				if (pval2 < TOPPvalues[MAXTOP]) {
					TOPPvalues2[MAXTOP] = pval2;
					TOPPorder2[MAXTOP] = BIGMARKER;
					strncpy(TOPSNPNAME2[MAXTOP], tempname, 100);
					vecsrt2(TOPPvalues2, TOPPorder2, TOPSNPNAME2, MAXTOP);

				}

				if (pval3 < TOPPvalues[MAXTOP]) {
					TOPPvalues3[MAXTOP] = pval3;
					TOPPorder3[MAXTOP] = BIGMARKER;

					strncpy(TOPSNPNAME3[MAXTOP], tempname, 100);
					vecsrt2(TOPPvalues3, TOPPorder3, TOPSNPNAME3, MAXTOP);

				}

			}
		}
		for (i = 1; i <= N; i++)
			genoflag[i] = 0;
		//	printf("\nNstu is %d.",Nstu);

//			time6 = clock();
//			duration_computetests +=(double)(time6-time5)/CLOCKS_PER_SEC;
	}

	if (genofile_read_status == -1) {
		printf(
				"A row in genofile has the number of entries not equal to the total number of individuals in pheotype file.\n");
		exit(1);
	}
//	time7 = clock();
//	duration_whileloop = (double)(time7-time1)/CLOCKS_PER_SEC;

	/*
	 printf("TOTAL MARKERS ANALYZED is %d and nonpolycount is %d\n",BIGMARKER,nonpolycount);
	 */

	fclose(pvfile);

	if (nfile == 1 && BIGMARKER != NAMECOUNT) {

		fprintf(stderr,
				"The number of SNPs in the genotype file and the number of SNP names provided by the user are not the same. The number of SNPs is %d, and the number of SNP names is %d \n",
				BIGMARKER, NAMECOUNT);
	}

	top = MAXTOP;
	if (MAXTOP >= BIGMARKER) {
		top = BIGMARKER;
	}

	if (X == 0 & HWE == 0) {
		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values: \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder[m], TOPSNPNAME[m], TOPPvalues[m]);
		}
/*
		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values using the Corrected Chi-Squred robust test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder2[m], TOPSNPNAME2[m], TOPPvalues2[m]);
		}

		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of top %d markers with the smallest p-values using the WQLS HWE test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder3[m], TOPSNPNAME3[m], TOPPvalues3[m]);
		}
*/
	}

	if (X == 0 & HWE == 1) {
		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values: \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder[m], TOPSNPNAME[m], TOPPvalues[m]);
		}
/*
		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values using the Corrected Chi-Squred HWE test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder2[m], TOPSNPNAME2[m], TOPPvalues2[m]);
		}

		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of top %d markers with the smallest p-values using the WQLS HWE test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder3[m], TOPSNPNAME3[m], TOPPvalues3[m]);
		}
*/
	}

	if (X == 1 & HWE == 0) {
		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values: \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder[m], TOPSNPNAME[m], TOPPvalues[m]);
		}
/*
		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values using the XCHI robust test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder2[m], TOPSNPNAME2[m], TOPPvalues2[m]);
		}

		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of top %d markers with the smallest p-values using the XW robust test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder3[m], TOPSNPNAME3[m], TOPPvalues3[m]);
		}
*/
	}

	if (X == 1 & HWE == 1) {
		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values: \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder[m], TOPSNPNAME[m], TOPPvalues[m]);
		}
/*
		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of the top %d markers with the smallest p-values using the XCHI HWE test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder2[m], TOPSNPNAME2[m], TOPPvalues2[m]);
		}

		fprintf(sigfile,
				"\n\n############################################### \n\n");

		fprintf(sigfile,
				"Below is a list of top %d markers with the smallest p-values using the XW HWE test statistic \n\n",
				top);
		fprintf(sigfile,
				"**************************************************\n\n");
		for (m = 1; m <= top; m++) {
			fprintf(sigfile, "MARKER %d: %s has a p-value of %g\n",
					TOPPorder3[m], TOPSNPNAME3[m], TOPPvalues3[m]);
		}
*/
	}

	fclose(sigfile);

	if (sfile == 1)
		fclose(FileSimResults);

	fclose(outfile);
/*	time8 = clock();
	duration_afterwhile = (double)(time8-time7)/CLOCKS_PER_SEC;
	clock_t done = clock();
	double diff_time = (double) (done - lauch) / CLOCKS_PER_SEC;
	printf("\n\nTotal time elapsed is %f.\n\n", diff_time);
	printf("Breakdown of total time:\nduration_preprocessing = %f\n",duration_preprocessing);
	printf("duration_computeXiorPhenoresid = %f\n",duration_computeXiorPhenoresid);
	printf("\nduration_globalchol is %f.\n",duration_keyline1);
	printf("duration_whileloop = %f\n",duration_whileloop);
	printf("duration_afterwhile = %f\n\n",duration_afterwhile);
	printf("Breakdown of duration_whileloop:\nduration_getgeno = %f\n",duration_getgeno);
	printf("duration_phenores = %f\n",duration_phenores);
	printf("duration_genovar_cov = %f\n",duration_genovar_cov);
	printf("duration_readGenotypes = %f\n",duration_readGenotypes);
	printf("duration_getFreq = %f\n",duration_getFreq);
	printf("duration_computetests = %f\n\n",duration_computetests);
	printf("Breakdown of duration_readGenotypes:\nduration_readGeno_line = %f\n", duration_readGeno_line);
	printf("duration_computeYRR1 = %f\n",duration_computeYRR1);
	printf("duration_cholesky = %f\n\n",duration_cholesky);
	printf("duration_keyline = %f\n", duration_keyline);
*/
	free_memory();
	for (j = 1; j <= F; j++) {
		free(genocovflagmatrix[j]);
		free(genoflagmatrix[j]);
	}
	free(genocovflagmatrix);
	free(genoflagmatrix);
	free(genoflag);
	free_dvector(logistic_coeff_var,1,Ncov);
	for (j = 1; j <= MAXTOP; j++) {
		free(TOPSNPNAME[j]);
		free(TOPSNPNAME2[j]);
		free(TOPSNPNAME3[j]);
	}
	free(TOPSNPNAME);
	free(TOPSNPNAME2);
	free(TOPSNPNAME3);
	fclose(errfile);
	free_dvector(TOPPvalues, 0, MAXTOP);
	free_dvector(TOPPvalues2, 0, MAXTOP);
	free_dvector(TOPPvalues3, 0, MAXTOP);
	free_ivector(TOPPorder, 0, MAXTOP);
	free_ivector(TOPPorder2, 0, MAXTOP);
	free_ivector(TOPPorder3, 0, MAXTOP);
	fclose(famfile);
	fclose(idfile);
	fclose(genofile);
	fclose(phenomodel_estimates_file);
	//delete the output file for debugging and simulation purpose
	if (sfile == 0) remove("CERAMICtest.out");
	if (sfile == 0 && X == 1) remove("CERAMICXtest.out");

	if (complete_data == 1) {

		for (i=1; i<=F; i++) {
			free_dmatrix(global_chol[i], 1, famdata[i].N, 1, famdata[i].N);
			free_dmatrix(global_chol1[i], 1, famdata[i].N, 1, famdata[i].N);
		}
		free(global_chol1);
		free(global_chol);
	}

	return 0;
}



void init_flags() {

	int i,j;
	genoflag = (int*) malloc((size_t) ((N + 1) * sizeof(int)));
	for (i = 1; i <= N; i++) genoflag[i] = 0;
	genoflagmatrix = (int **) malloc((size_t) ((F + 1) * sizeof(int*)));
	for (j = 1; j <= F; j++) {
		genoflagmatrix[j] = (int *) malloc(
				(size_t) ((famdata[j].N + 1) * sizeof(int)));
	}
	genocovflagmatrix = (int **) malloc((size_t) ((F + 1) * sizeof(int*)));
	for (j = 1; j <= F; j++) {
		genocovflagmatrix[j] = (int *) malloc(
				(size_t) ((famdata[j].N + 1) * sizeof(int)));
	}
}


void init_TOPSNPs(int nfile, char *name) {

	int i,j;

	TOPPvalues = dvector(0, MAXTOP);
	TOPPvalues2 = dvector(0, MAXTOP);
	TOPPvalues3 = dvector(0, MAXTOP);
	TOPPorder = ivector(0, MAXTOP);
	TOPPorder2 = ivector(0, MAXTOP);
	TOPPorder3 = ivector(0, MAXTOP);

	//Count the number of names in SNP name file
	if (nfile == 1) {
		getsnpnamefile(name);
	}

	TOPSNPNAME = (char **) malloc((size_t) ((MAXTOP + 1) * sizeof(char*)));
	TOPSNPNAME2 = (char **) malloc((size_t) ((MAXTOP + 1) * sizeof(char*)));
	TOPSNPNAME3 = (char **) malloc((size_t) ((MAXTOP + 1) * sizeof(char*)));

	for (j = 1; j <= MAXTOP; j++) {
		TOPSNPNAME[j] = (char *) malloc((size_t) ((100) * sizeof(char)));
		TOPSNPNAME2[j] = (char *) malloc((size_t) ((100) * sizeof(char)));
		TOPSNPNAME3[j] = (char *) malloc((size_t) ((100) * sizeof(char)));

	}
}

void print_header() {

	if (X == 0) {

		if ((sigfile = fopen("CERAMICtest.top", "w")) == NULL ) {
			printf("Can't open CERAMICtest.top.\n");
			exit(1);
		}

		if ((pvfile = fopen("CERAMICtest.pvalues", "w")) == NULL ) {
			printf("Can't open CERAMICtest.pvalues.\n");
			exit(1);
		}

		if ((outfile = fopen("CERAMICtest.out", "w")) == NULL ) {
			printf("Can't open CERAMICtest.out .\n");
			exit(1);
		}

	}

	if (X == 1) {

		if ((sigfile = fopen("CERAMICXtest.top", "w")) == NULL ) {
			printf("Can't open CERAMICXtest.top.\n");
			exit(1);
		}

		if ((pvfile = fopen("CERAMICXtest.pvalues", "w")) == NULL ) {
			printf("Can't open CERAMICXtest.pvalues.\n");
			exit(1);
		}

		if ((outfile = fopen("CERAMICXtest.out", "w")) == NULL ) {
			printf("Can't open CERAMICXtest.out .\n");
			exit(1);
		}

	}

	fprintf(outfile,
			"******Results of the Case-control Association tests ******\n\n");

	if (Option == 1) {
		fprintf(outfile,
				"There are %d individuals from %d independent families. %d of the individuals are affected, %d of the individuals are unaffected, and %d of the individuals are of unknown phenotype.\n\n",
				NPheno, F, Naffected, NUnaffected, NUnknown);
	}

	if (Option == 2) {
		fprintf(outfile,
				"There are %d individuals from %d independent families. %d of the individuals are affected, %d of the individuals are unaffected, and %d are of unknown phenotype.  The -u option was chosen by the user so individuals with unknown phenotypes were not used in the analysis.\n\n",
				NPheno, F, Naffected, NUnaffected, NUnknown);
	}




	if (X == 0) {
		if (HWE == 0) {
			fprintf(pvfile,
					"SNP \t NAME \t   \t  CERAMIC_Robust \n");
		} else {
			fprintf(pvfile,
					"SNP \t NAME \t   \t  CERAMIC_HWE \n");
		}
	} else {

		if (HWE == 0) {
			fprintf(pvfile,
					"SNP \t NAME \t  \t  CERAMICX_Robust \n");
		} else {
			fprintf(pvfile,
					"SNP \t NAME \t  \t  CERAMICX_HWE \n");
		}

	}
}


//get the covariates and affection status for individuals having non-missing phenotype and covariates
void readcov2(double **StoreCov, double *yaffec, int *flag) {
	int i, j;
	int aff;
	int tot = 0;
	if (noCov == 1) {
		for (i = 1; i <= N; i++) {
			fscanf(famfile, "%*d %*d %d\n", &aff);
			if (!(aff == 1 || aff == 2)) {
				flag[i] = 0;
				continue;
			}
			tot++;
			yaffec[tot] = aff;
			StoreCov[tot][1] = 1;
		}
	} else {
		tot = 0;
		double *cov;
		cov = dvector(1, Ncov - 1);
		for (i = 1; i <= N; i++) {
			fscanf(famfile, "%*d %*d %d ", &aff);
			if (!(aff == 1 || aff == 2))
				flag[i] = 0;
			for (j = 1; j <= (Ncov - 1); j++) {
				fscanf(famfile, "%lf ", &cov[j]);
				if (cov[j] == MISSINGVAL) {
					flag[i] = 0;
				}
			}
			if (flag[i] == 0)
				continue;
			tot++;
			yaffec[tot] = aff;
			StoreCov[tot][1] = 1;
			for (j = 1; j <= (Ncov - 1); j++) {
				StoreCov[tot][j + 1] = cov[j];
			}

		}
		free_dvector(cov, 1, Ncov - 1);
	}
	rewind(famfile);
}
void getsnpnamefile(char *name) {

	int all1 = 0, all2 = 0, fam = 0, famold = 1, n = 0;
	int indnumber = 0, ind = 0, nloci;
	char str1[100];

	if ((fsnpname = fopen(name, "r")) == NULL ) {
		printf("Can't open MARKER NAME FILE %s\n", name);
		exit(1);
	}

	nloci = 0;
	while ((fscanf(fsnpname, "%s ", str1)) == 1) {
		nloci++;

	}

	NAMECOUNT = nloci;

	rewind(fsnpname);

}
int getgenoline(struct MARKER *Mark, struct FAM *famdata, FILE *errfile) {

/*	clock_t t1, t2, t3, t4, t5, t6;
	double duration1=0.0, duration2=0.0, duration3=0.0, duration4=0.0, duration5=0.0, duration6=0.0;
	t1 = clock();
*/
	int all1 = 0, all2 = 0, fam = 0, famold = 1, n = 0;
	char line[MAXLINE];
	int length = MAXLINE;
	int Ngenotypes = 0;
	int status = 0, indnumber = 0, ind = 0, m = 0, indiv = 0, sex = 0;
	int i, j, k, l;
	int MYCONTINUE, genovalue, mytyped = 0, pers1, pers2, num;
	void *p_gets = NULL;
	int allele_first_appear = 0;

	p_gets = fgets(line, length, genofile);

	if (p_gets == NULL) {
		if (BIGMARKER == 0) {
			printf(
					"No marker to test. Please check first line in marker data file\n\n");
			exit(1);
		} else
			MYCONTINUE = 0;
	} else {
		MYCONTINUE = 1;
	}

	if (MYCONTINUE == 1) {
		m = 1;

		Mark[1].Nball = 0;
		Mark[1].Nc = 0;
		Mark[1].Nt = 0;
		Mark[1].Nu = 0;

		for (i = 1; i <= F; i++) {
			Mark[1].typed[i].N = 0;
			Mark[1].typed[i].Nc = 0;
			Mark[1].typed[i].Nt = 0;
			Mark[1].typed[i].Nu = 0;

		}

		num = 0;

		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].N; j++) {
				n = sscanf(line, "%d %[^\n]", &genovalue, line);
				if (i == F && j == famdata[i].N) {
					if (n != 1) {
						MYCONTINUE = -1;
						break;
					}
				} else {
					if (n != 2) {
						MYCONTINUE = -1;
						break;
					}
				}
				num++;

				if (genovalue == 2 || genovalue == 1 || genovalue == 0) {

					genoflag[num] = 1;
					genoflagmatrix[i][j] = 1;

					mytyped++;

					/*
					 GENOTYPED[num]=1;
					 */

					/* printf("%d %d %d \n",i,j,FINALTYPED[mytyped]); */

					if (genovalue == 2) {
						all1 = 1;
						all2 = 1;
					}

					if (genovalue == 1) {
						all1 = 1;
						all2 = 2;
					}

					if (genovalue == 0) {
						all1 = 2;
						all2 = 2;
					}
				}

				else {
					genoflagmatrix[i][j] = 0;
					all1 = 0;
					all2 = 0;
					/*     GENOTYPED[num]=0; */
				}

				fam = i;
				indnumber = j;
				status = famdata[i].AFFEC[j][2];
				ind = famdata[i].descri[j];
				/* sex=famdata[i].SEX[j]; */

				Mark[1].mark[fam][indnumber][1] = all1;
				Mark[1].mark[fam][indnumber][2] = all2;
				Mark[1].mark[fam][indnumber][3] = status;
				Mark[1].mark[fam][indnumber][4] = ind;
				/* Mark[1].mark[fam][indnumber][5]=sex;*/
				if ((status == 0 || status == 1) && all1 != 0 && all2 != 0) {

					Mark[1].typed[fam].N++;

					if (status == 1) {
						Mark[1].typed[fam].Nt++;
						Mark[1].Nt++;
					}

					if (status == 0) {
						Mark[1].Nu++;
						Mark[1].typed[fam].Nu++;
					}
				}

				else if (status == 2 && all1 != 0 && all2 != 0) {
					Mark[1].typed[fam].Nc++;
					Mark[1].typed[fam].N++;
					Mark[1].Nc++;
				}
				/*		if (all1 > Mark[1].Nball)
				 Mark[1].Nball = all1;
				 if (all2 > Mark[1].Nball)
				 Mark[1].Nball = all2;*/

				if (all1 > 0 && allele_first_appear == 0) {
					allele_first_appear = all1;
					Mark[1].Nball = 1;
				}
				if (all2 > 0 && allele_first_appear == 0) {
					allele_first_appear = all2;
					Mark[1].Nball = 1;
				}
				if (Mark[1].Nball == 1 && allele_first_appear != all1
						&& all1 > 0)
					Mark[1].Nball = 2;
				if (Mark[1].Nball == 1 && allele_first_appear != all2
						&& all2 > 0)
					Mark[1].Nball = 2;

			}
			if (MYCONTINUE == -1)
				break;
		}

	}

	if (MYCONTINUE == 1) {
		TYPEDNUM = mytyped;
		/*  printf("There are %d total typed for marker %d \n",mytyped,BIGMARKER); */
	}

	/*	t2 = clock();
	 duration1 = (double) (t2-t1)/CLOCKS_PER_SEC;
	 printf("\nd1 is %f, d2 is %f.",duration1, duration2);
	 exit(1);

	 */
	return (MYCONTINUE);
}

int getgenoline_fast(struct MARKER *Mark, struct FAM *famdata, FILE *errfile) {

/*	clock_t t1, t2, t3, t4, t5, t6;
	double duration1=0.0, duration2=0.0, duration3=0.0, duration4=0.0, duration5=0.0, duration6=0.0;
	t1 = clock();
*/
	int all1 = 0, all2 = 0, fam = 0, famold = 1, n = 0;
	int Ngenotypes = 0;
	int status = 0, indnumber = 0, ind = 0, m = 0, indiv = 0, sex = 0;
	int i, j, k, l;
	int MYCONTINUE, genovalue, mytyped = 0, pers1, pers2, num;
	int allele_first_appear = 0;

	   MYCONTINUE = 1;

		m = 1;

		Mark[1].Nball = 0;
		Mark[1].Nc = 0;
		Mark[1].Nt = 0;
		Mark[1].Nu = 0;

		for (i = 1; i <= F; i++) {
			Mark[1].typed[i].N = 0;
			Mark[1].typed[i].Nc = 0;
			Mark[1].typed[i].Nt = 0;
			Mark[1].typed[i].Nu = 0;

		}

		num = 0;


		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].N; j++) {


				if (i==F && j==famdata[F].N){
					n = fscanf(genofile, "%d\n", &genovalue);
				} else {
					n = fscanf(genofile, "%d ", &genovalue);
				}

				if (n!=1) {
				if (i==1 && j==1) {
					if (BIGMARKER ==0) {
						printf("No marker to test. Please check first line in marker data file\n\n");
						exit(1);
					} else {
						MYCONTINUE = 0;
						break;
					}
				} else {
					MYCONTINUE = -1;
					break;
				}
				} else {
					MYCONTINUE = 1;
				}
				num++;

				if (genovalue == 2 || genovalue == 1 || genovalue == 0) {

					genoflag[num] = 1;
					genoflagmatrix[i][j] = 1;

					mytyped++;

					/*
					 GENOTYPED[num]=1;
					 */

					/* printf("%d %d %d \n",i,j,FINALTYPED[mytyped]); */

					if (genovalue == 2) {
						all1 = 1;
						all2 = 1;
					}

					if (genovalue == 1) {
						all1 = 1;
						all2 = 2;
					}

					if (genovalue == 0) {
						all1 = 2;
						all2 = 2;
					}
				}

				else {
					genoflagmatrix[i][j] = 0;
					all1 = 0;
					all2 = 0;
					/*     GENOTYPED[num]=0; */
				}

				fam = i;
				indnumber = j;
				status = famdata[i].AFFEC[j][2];
				ind = famdata[i].descri[j];
				/* sex=famdata[i].SEX[j]; */

				Mark[1].mark[fam][indnumber][1] = all1;
				Mark[1].mark[fam][indnumber][2] = all2;
				Mark[1].mark[fam][indnumber][3] = status;
				Mark[1].mark[fam][indnumber][4] = ind;
				/* Mark[1].mark[fam][indnumber][5]=sex;*/
				if ((status == 0 || status == 1) && all1 != 0 && all2 != 0) {

					Mark[1].typed[fam].N++;

					if (status == 1) {
						Mark[1].typed[fam].Nt++;
						Mark[1].Nt++;
					}

					if (status == 0) {
						Mark[1].Nu++;
						Mark[1].typed[fam].Nu++;
					}
				}

				else if (status == 2 && all1 != 0 && all2 != 0) {
					Mark[1].typed[fam].Nc++;
					Mark[1].typed[fam].N++;
					Mark[1].Nc++;
				}
				/*		if (all1 > Mark[1].Nball)
				 Mark[1].Nball = all1;
				 if (all2 > Mark[1].Nball)
				 Mark[1].Nball = all2;*/

				if (all1 > 0 && allele_first_appear == 0) {
					allele_first_appear = all1;
					Mark[1].Nball = 1;
				}
				if (all2 > 0 && allele_first_appear == 0) {
					allele_first_appear = all2;
					Mark[1].Nball = 1;
				}
				if (Mark[1].Nball == 1 && allele_first_appear != all1
						&& all1 > 0)
					Mark[1].Nball = 2;
				if (Mark[1].Nball == 1 && allele_first_appear != all2
						&& all2 > 0)
					Mark[1].Nball = 2;

			}
			if (MYCONTINUE != 1)
				break;
		}


		//printf("MYCONTINUE is %d!\n",MYCONTINUE);

	if (MYCONTINUE == 1) {
		TYPEDNUM = mytyped;
		/*  printf("There are %d total typed for marker %d \n",mytyped,BIGMARKER); */
	}

	/*	t2 = clock();
	 duration1 = (double) (t2-t1)/CLOCKS_PER_SEC;
	 printf("\nd1 is %f, d2 is %f.",duration1, duration2);
	 exit(1);

	 */
	return (MYCONTINUE);
}

int getgenoline_binary(struct MARKER *Mark, struct FAM *famdata, FILE *errfile) {
	int all1 = 0, all2 = 0, fam = 0;
	int status = 0, indnumber = 0, ind = 0, m = 0;
	int i, j;
	int MYCONTINUE, genovalue, mytyped = 0, num;
	int allele_first_appear = 0;

	signed char current_row[N];
	if (fread(current_row, sizeof(signed char), N, genofile) == N) {
		MYCONTINUE = 1;
		m = 1;

		Mark[1].Nball = 0;
		Mark[1].Nc = 0;
		Mark[1].Nt = 0;
		Mark[1].Nu = 0;

		for (i = 1; i <= F; i++) {
			Mark[1].typed[i].N = 0;
			Mark[1].typed[i].Nc = 0;
			Mark[1].typed[i].Nt = 0;
			Mark[1].typed[i].Nu = 0;

		}

		num = 0;

		int tot = -1;
		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].N; j++) {
				tot++;
				genovalue = (int) current_row[tot];
				//	printf("genovalue is %d.\n",genovalue);
				//	if (genovalue<0) printf("tot is %d.\n",tot+1);
				num++;

				if (genovalue == 2 || genovalue == 1 || genovalue == 0) {

					genoflag[num] = 1;
					genoflagmatrix[i][j] = 1;

					mytyped++;

					/*
					 GENOTYPED[num]=1;
					 */

					/* printf("%d %d %d \n",i,j,FINALTYPED[mytyped]); */

					if (genovalue == 2) {
						all1 = 1;
						all2 = 1;
					}

					if (genovalue == 1) {
						all1 = 1;
						all2 = 2;
					}

					if (genovalue == 0) {
						all1 = 2;
						all2 = 2;
					}
				}

				else {
					genoflagmatrix[i][j] = 0;
					all1 = 0;
					all2 = 0;
					/*     GENOTYPED[num]=0; */
				}

				fam = i;
				indnumber = j;
				status = famdata[i].AFFEC[j][2];
				ind = famdata[i].descri[j];
				/* sex=famdata[i].SEX[j]; */

				Mark[1].mark[fam][indnumber][1] = all1;
				Mark[1].mark[fam][indnumber][2] = all2;
				Mark[1].mark[fam][indnumber][3] = status;
				Mark[1].mark[fam][indnumber][4] = ind;
				/* Mark[1].mark[fam][indnumber][5]=sex;*/
				if ((status == 0 || status == 1) && all1 != 0 && all2 != 0) {

					Mark[1].typed[fam].N++;

					if (status == 1) {
						Mark[1].typed[fam].Nt++;
						Mark[1].Nt++;
					}

					if (status == 0) {
						Mark[1].Nu++;
						Mark[1].typed[fam].Nu++;
					}
				}

				else if (status == 2 && all1 != 0 && all2 != 0) {
					Mark[1].typed[fam].Nc++;
					Mark[1].typed[fam].N++;
					Mark[1].Nc++;
				}
				/*		if (all1 > Mark[1].Nball)
				 Mark[1].Nball = all1;
				 if (all2 > Mark[1].Nball)
				 Mark[1].Nball = all2;*/
				if (all1 > 0 && allele_first_appear == 0) {
					allele_first_appear = all1;
					Mark[1].Nball = 1;
				}
				if (all2 > 0 && allele_first_appear == 0) {
					allele_first_appear = all2;
					Mark[1].Nball = 1;
				}
				if (Mark[1].Nball == 1 && allele_first_appear != all1
						&& all1 > 0)
					Mark[1].Nball = 2;
				if (Mark[1].Nball == 1 && allele_first_appear != all2
						&& all2 > 0)
					Mark[1].Nball = 2;

//if (BIGMARKER == 1093) printf("%d \n", Mark[1].Nball);

			}
		}
		// printf("%d \n", Mark[1].Nball);

	} else {
		MYCONTINUE = 0;
	}

	if (MYCONTINUE == 1) {
		TYPEDNUM = mytyped;
		/*  printf("There are %d total typed for marker %d \n",mytyped,BIGMARKER); */
	}

	/*	t2 = clock();
	 duration1 = (double) (t2-t1)/CLOCKS_PER_SEC;
	 printf("\nd1 is %f, d2 is %f.",duration1, duration2);
	 exit(1);

	 */
	return (MYCONTINUE);

}

//get the covariates and affection status for individuals having non-missing phenotype and covariates
//individuals that are phenotyped but not genotyped are excluded
void readcov3(double **StoreCov, double *yaffec, int *flag, int *genoflag) {
	int i, j;
	int aff;
	int tot = 0;
	if (noCov == 1) {
		for (i = 1; i <= N; i++) {
			fscanf(famfile, "%*d %*d %d\n", &aff);
			if (!(aff == 1 || aff == 2) || genoflag[i] == 0) {
				flag[i] = 0;
				continue;
			}
			tot++;
			yaffec[tot] = aff;
			StoreCov[tot][1] = 1;

		}

	} else {
		double *cov;
		cov = dvector(1, Ncov - 1);
		tot = 0;
		for (i = 1; i <= N; i++) {
			fscanf(famfile, "%*d %*d %d ", &aff);
			if (!(aff == 1 || aff == 2) || genoflag[i] == 0)
				flag[i] = 0;
			for (j = 1; j <= (Ncov - 1); j++) {
				fscanf(famfile, "%lf ", &cov[j]);
				if (cov[j] == MISSINGVAL)
					flag[i] = 0;
			}
			if (flag[i] == 0)
				continue;
			tot++;
			yaffec[tot] = aff;
			StoreCov[tot][1] = 1;
			for (j = 1; j <= (Ncov - 1); j++) {
				StoreCov[tot][j + 1] = cov[j];
			}

		}
		free_dvector(cov, 1, Ncov - 1);
	}
	rewind(famfile);
}

void readcov4(int** genoflagmatrix, int **genocovflagmatrix) {
	int i, j, k;
	int aff;
	if (noCov == 1) {
		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].N; j++) {
				genocovflagmatrix[i][j] = 1;
				fscanf(famfile, "%*d %*d %d ", &aff);
				if (genoflagmatrix[i][j] == 0
						|| ((Option == 2) && !(aff == 1 || aff == 2))) {
					genocovflagmatrix[i][j] = 0;
				}
			}
		}
	} else {
		double *cov;
		cov = dvector(1, Ncov - 1);
		for (i = 1; i <= F; i++) {
			for (j = 1; j <= famdata[i].N; j++) {
				genocovflagmatrix[i][j] = 1;
				fscanf(famfile, "%*d %*d %d ", &aff);
				if (genoflagmatrix[i][j] == 0
						|| ((Option == 2) && !(aff == 1 || aff == 2)))
					genocovflagmatrix[i][j] = 0;
				for (k = 1; k <= (Ncov - 1); k++) {
					fscanf(famfile, "%lf ", &cov[k]);
					if (cov[k] == MISSINGVAL)
						genocovflagmatrix[i][j] = 0;
				}
			}
		}
		free_dvector(cov, 1, Ncov - 1);
	}
	rewind(famfile);
}

void computeYRandR1(double **cholaug, double *YRvector, double *R1value,
		int size) {
	int i = 0, j = 0;
	for (i = 1; i <= M; i++) {
		for (j = 1; j <= size; j++) {
			YRvector[i] += cholaug[j][i] * cholaug[j][M + 2];
		}
	}
	for (j = 1; j <= size; j++) {
		*R1value += cholaug[j][M + 2];
	}

}

void readGenotypes(int fam, int m, int length, double **cholaug,
		double **cholaugCase, double **cholaugControl, double **cholaugUnknown,
		int *MissingVec, int miss, double **kincoefmatrix,
		double **kincoefMatrixCase, double **kincoefmatrixControl,
		double **kincoefmatrixUnknown) {
	int all1 = 0, all2 = 0, j = 0, i = 0, family = 0, follow = 0;
	int a1 = 0, tot = 1, controls = 1, cases = 1, unknown = 1;
	int nbc1 = 0, nbc2 = 0, nbt1 = 0, nbt2 = 0, nb1 = 0, nb2 = 0, nbu1 = 0,
			nbu2 = 0;
	double val1 = 0;
	int k, num;

	k = m;

	for (i = 1; i <= length; i++) //length is famdata[fam].Pheno
			{

		val1 = 0;
		if (Mark[1].mark[fam][i][1] != 0 && Mark[1].mark[fam][i][2] != 0) {
			nb1++;
			nb2 = nb1;
			if (Storekin[fam][i][i] == -1) {
				printf(
						"No inbreeding coefficient for individual %d from family %d. Please check...\n\n",
						i, fam);
				exit(1);
			}

			kincoefmatrix[nb1][nb1] = Storekin[fam][i][i] + 1;

			if (Mark[1].mark[fam][i][3] == 2) {
				nbc1++;
				nbc2 = nbc1;
				kincoefMatrixCase[nbc1][nbc1] = kincoefmatrix[nb2][nb1];

				for (j = i + 1; j <= length; j++) {
					if (Storekin[fam][i][j] == -1) {
						printf(
								"No kinship coefficient between individual %d and individual %d from family %d. Please check...\n\n",
								famdata[fam].descri[i], famdata[fam].descri[j],
								fam);
						exit(1);
					}

					if (Mark[1].mark[fam][j][1] != 0
							&& Mark[1].mark[fam][j][2] != 0) {
						nb2++;
						kincoefmatrix[nb1][nb2] = 2 * Storekin[fam][i][j];
						kincoefmatrix[nb2][nb1] = kincoefmatrix[nb1][nb2];

						if (Mark[1].mark[fam][j][3] == 2) {
							nbc2++;
							kincoefMatrixCase[nbc1][nbc2] =
									kincoefmatrix[nb1][nb2];
							kincoefMatrixCase[nbc2][nbc1] =
									kincoefMatrixCase[nbc1][nbc2];
						}
					}
				}

				cholaug[tot][M + 1] = 2;

				cholaugCase[cases][M + 1] = 2;

				cholaug[tot][M + 2] = 2 * famdata[fam].CorrectedAFFEC[i][2];
				cholaugCase[cases][M + 2] = 2
						* famdata[fam].CorrectedAFFEC[i][2];

				/*	if(famdata[fam].MZ[i][1]!=-10)
				 {cholaug[tot][M+2]=2*famdata[fam].MZ[i][2];
				 cholaugCase[cases][M+2]=2*famdata[fam].MZ[i][2];
				 printf("allocated the MZ case\n"); */

				//}

				for (a1 = 1; a1 <= M; a1++)

					cholaug[tot][a1] = 0;

				for (a1 = 1; a1 <= M; a1++) {
					if (Mark[1].mark[fam][i][1] == a1)
						cholaug[tot][a1]++;
					if (Mark[1].mark[fam][i][2] == a1)
						cholaug[tot][a1]++;
					cholaugCase[cases][a1] = cholaug[tot][a1];

				}
				cases++;
				tot++;

			}

			else if (Mark[1].mark[fam][i][3] == 1) {
				nbt1++;
				nbt2 = nbt1;
				kincoefmatrixControl[nbt1][nbt1] = kincoefmatrix[nb2][nb1];

				for (j = i + 1; j <= length; j++) {
					if (Mark[1].mark[fam][j][1] != 0
							&& Mark[1].mark[fam][j][2] != 0) {
						nb2++;
						kincoefmatrix[nb1][nb2] = 2 * Storekin[fam][i][j];
						kincoefmatrix[nb2][nb1] = kincoefmatrix[nb1][nb2];

						if (Mark[1].mark[fam][j][3] == 1) {
							nbt2++;
							kincoefmatrixControl[nbt1][nbt2] =
									kincoefmatrix[nb1][nb2];
							kincoefmatrixControl[nbt2][nbt1] =
									kincoefmatrixControl[nbt1][nbt2];
						}
					}
				}

				cholaug[tot][M + 1] = 2;
				cholaugControl[controls][M + 1] = 2;

				cholaug[tot][M + 2] = 2 * famdata[fam].CorrectedAFFEC[i][2];
				cholaugControl[controls][M + 2] = 2
						* famdata[fam].CorrectedAFFEC[i][2];

				/*if(famdata[fam].MZ[i][1]!=-10)
				 {
				 cholaug[tot][M+2]=2*famdata[fam].MZ[i][2];
				 cholaugControl[controls][M+2]=2*famdata[fam].MZ[i][2];
				 /* printf("allocated the MZ control\n");  */
				//}

				for (a1 = 1; a1 <= M; a1++)
					cholaug[tot][a1] = 0;
				for (a1 = 1; a1 <= M; a1++) {
					if (Mark[1].mark[fam][i][1] == a1)
						cholaug[tot][a1]++;
					if (Mark[1].mark[fam][i][2] == a1)
						cholaug[tot][a1]++;
					cholaugControl[controls][a1] = cholaug[tot][a1];

				}
				controls++;
				tot++;

			}

			else if (Mark[1].mark[fam][i][3] == 0) {
				nbu1++;
				nbu2 = nbu1;
				kincoefmatrixUnknown[nbu1][nbu1] = kincoefmatrix[nb2][nb1];

				for (j = i + 1; j <= length; j++) {
					if (Mark[1].mark[fam][j][1] != 0
							&& Mark[1].mark[fam][j][2] != 0) {
						nb2++;
						kincoefmatrix[nb1][nb2] = 2 * Storekin[fam][i][j];
						kincoefmatrix[nb2][nb1] = kincoefmatrix[nb1][nb2];

						if (Mark[1].mark[fam][j][3] == 0) {
							nbu2++;
							kincoefmatrixUnknown[nbu1][nbu2] =
									kincoefmatrix[nb1][nb2];
							kincoefmatrixUnknown[nbu2][nbu1] =
									kincoefmatrixUnknown[nbu1][nbu2];
						}
					}
				}

				cholaug[tot][M + 1] = 2;
				cholaugUnknown[unknown][M + 1] = 2;

				cholaug[tot][M + 2] = 2 * famdata[fam].CorrectedAFFEC[i][2];
				cholaugUnknown[unknown][M + 2] = 2
						* famdata[fam].CorrectedAFFEC[i][2];

				/*if(famdata[fam].MZ[i][1]!=-10)
				 {
				 cholaug[tot][M+2]=2*famdata[fam].MZ[i][2];
				 cholaugUnknown[unknown][M+2]=2*famdata[fam].MZ[i][2];
				 /* printf("allocated the MZ control\n");  */
				//}

				for (a1 = 1; a1 <= M; a1++)
					cholaug[tot][a1] = 0;
				for (a1 = 1; a1 <= M; a1++) {
					if (Mark[1].mark[fam][i][1] == a1)
						cholaug[tot][a1]++;
					if (Mark[1].mark[fam][i][2] == a1)
						cholaug[tot][a1]++;
					cholaugUnknown[unknown][a1] = cholaug[tot][a1];

				}
				unknown++;
				tot++;

			}

		}

		else {
			follow++;
			/* MissingVec[follow]=i; */
		}

	}

	/*
	 if ((cases-1)!=Mark[1].typed[fam].Nc || (controls-1)!=Mark[1].typed[fam].Nt) {printf("Problems while rereading the data file...\n");
	 exit(1);
	 }
	 if (follow!=miss) {printf("problem with missing data in family %d follow=%d miss=%d\n",fam,follow,miss);
	 exit(1);}
	 */

	/** This is to get the phenotype vector for CERAMIC statistic  **/

	tot = 0;
	if (Missing == 1) {

		for (i = 1; i <= length; i++) {
			val1 = 0;
			if (Mark[1].mark[fam][i][1] != 0 && Mark[1].mark[fam][i][2] != 0) {
				tot++;
				val1 += (1 + Storekin[fam][i][i])
						* famdata[fam].CorrectedAFFEC[i][3];
				for (j = 1; j <= length; j++) {
					if (j != i)
						val1 += 2 * Storekin[fam][i][j]
								* famdata[fam].CorrectedAFFEC[j][3];
				}
				cholaug[tot][M + 3] = 2 * val1;
			}

		}
	}

	nb1 = 0;
	if (Missing == 2) {

		for (i = 1; i <= length; i++) {
			val1 = 0;
			if (Mark[1].mark[fam][i][1] != 0 && Mark[1].mark[fam][i][2] != 0) {
				nb1++;
				val1 += (1 + Storekin[fam][i][i])
						* famdata[fam].CorrectedAFFEC[i][3];
				nb2 = 0;
				for (j = 1; j <= length; j++) {
					if (Mark[1].mark[fam][j][1] != 0
							&& Mark[1].mark[fam][j][2] != 0) {
						nb2++;
						if (j != i)
							val1 += kincoefmatrix[nb1][nb2]
									* famdata[fam].CorrectedAFFEC[j][3];
					}

				}
				cholaug[nb1][M + 3] = 2 * val1;

			}

		}
	}

}

/******************************************************
 Computes the frequency estimates using the quasilikelihood approach
 *****************************************************/
void alleleFreq(double **cholaug, double *frequency, int size,
		double *denominator) {
	int i = 0, j = 0;
	double pasden = 0, numerator = 0;

	for (i = 1; i <= size; i++) {
		pasden = pasden + (cholaug[i][M + 1]) * (cholaug[i][M + 1]);

	}

	for (j = 1; j <= M; j++) {
		for (i = 1; i <= size; i++) {
			numerator = numerator + cholaug[i][M + 1] * cholaug[i][j];
		}
		frequency[j] += numerator;
		numerator = 0;
	}

	*denominator += pasden;
}

/******************************************************
 Computes the frequency estimates using the naive counting
 *****************************************************/
void naiveCount(double **cholaug, double *Naive, double *Naivefreq, int size) {
	int i = 0, j = 0;
	double sum = 0, contC = 0;

	for (i = 1; i <= M; i++) {
		contC = 0;
		for (j = 1; j <= size; j++) {
			sum += cholaug[j][i];
			if (cholaug[j][M + 2] == 2)
				contC += cholaug[j][i];

		}
		Naive[i] += contC;
		Naivefreq[i] += sum;
		sum = 0;

	}

}
/******************************************************
 Computes the information components required to derive the correction factor for the chi2 test
 *****************************************************/
void comput_info_chi2(double **kincoefMatrix, double **cholaug, double *info_rr,
		double *info_rf, double *info_ff, int size) {
	int i, j;
	double infopas_rr = 0, infopas_rf = 0, infopas_ff = 0;

	for (i = 1; i <= size; i++) {
		for (j = 1; j <= size; j++) {
			infopas_rr += cholaug[i][M + 2] * kincoefMatrix[i][j]
					* cholaug[j][M + 2];
			infopas_rf += cholaug[i][M + 2] * kincoefMatrix[i][j]
					* cholaug[j][M + 1];
			infopas_ff += cholaug[i][M + 1] * kincoefMatrix[i][j]
					* cholaug[j][M + 1];
		}

	}
	*info_rr += infopas_rr;
	*info_rf += infopas_rf;
	*info_ff += infopas_ff;

}

void robustvar(double **cholaug, double *ROBUST_11, double *YYvector,
		double *Y1vector, int size, int *Nstu) {
	int i, j;
	double info_rr = 0, info_rf = 0, info = 0, info_ff = 0, robust_11 = 0;

	for (i = 1; i <= size; i++) {
		robust_11 += cholaug[i][M + 1] * cholaug[i][M + 1];
		for (j = 1; j <= M; j++) {
			YYvector[j] += cholaug[i][j] * cholaug[i][j];
			Y1vector[j] += cholaug[i][M + 1] * cholaug[i][j];
		}
	}

	*ROBUST_11 += robust_11;
	*Nstu += size;

}
/******************************************************
 To get from counts to frequencies
 *****************************************************/
void getfrequency(double *Naivefreq, double *NaivefreqCase,
		double *NaivefreqControl, double *NaivefreqUnknown, double *frequency,
		double *frequencyCase, double *frequencyControl,
		double *frequencyUnknown, double denominator, double denomcases,
		double denomcontrols, double denomunknown, int Nall, int Ncase,
		int Ncontrol, int Nunknown) {
	int i;

	for (i = 1; i <= M; i++) {

		if (Nall > 0) {
			Naivefreq[i] /= (2 * Nall);
		}

		if (Ncase > 0) {
			NaivefreqCase[i] /= (2 * Ncase);
		}

		if (Ncontrol > 0) {
			NaivefreqControl[i] /= (2 * Ncontrol);
		}
		if (Nunknown > 0) {
			NaivefreqUnknown[i] /= (2 * Nunknown);
		}

		if (denominator > 0) {
			frequency[i] /= denominator;
		}

		if (denomcases > 0) {
			frequencyCase[i] /= denomcases;
		}

		if (denomcontrols > 0) {
			frequencyControl[i] /= denomcontrols;
		}

		if (denomunknown > 0) {
			frequencyUnknown[i] /= denomunknown;
		}

	}
}

/******************************************************
 Build the freqMatrix (a function of allele frequencies) required for the score computation in the multiallelic case
 *****************************************************/
int makeFreqMat(double **freqMatrix, double *frequency) {
	int i, j, k = 0, l = 0, Mpas = M;
	int *Followfreq;
	double **transMat, **freqPasMat;
	double **cholm, **invcholm;

	//printf(" Inside Mat M is %d %d.\n", M, Mpas );
	if (M > 1)
		Followfreq = ivector(1, M - 1);

	for (i = 1; i <= M - 1; i++) {
		Followfreq[i] = 1;
		if (frequency[i] == 0) {
			Mpas--;
			Followfreq[i] = 0;
		}
	}

	if (Mpas == 1) {
		for (i = 1; i != M; i++)
			for (j = 1; j != M; j++)
				freqMatrix[i][j] = 0;
		return 0;
	}

	transMat = dmatrix(1, Mpas - 1, 1, Mpas - 1);
	cholm = dmatrix(1, Mpas - 1, 1, Mpas - 1);
	invcholm = dmatrix(1, Mpas - 1, 1, Mpas - 1);
	freqPasMat = dmatrix(1, Mpas - 1, 1, Mpas - 1);

	for (i = 1; i <= Mpas - 1; i++)
		for (j = 1; j <= Mpas - 1; j++) {
			transMat[i][j] = 0;
			cholm[i][j] = 0;
			invcholm[i][j] = 0;
			freqPasMat[i][j] = 0;
		}

	for (i = 1; i <= M - 1; i++)
		if (Followfreq[i] == 1) {
			k++;
			transMat[k][k] = frequency[i] * (1 - frequency[i]);
			l = k;
			for (j = i + 1; j <= M - 1; j++)
				if (Followfreq[j] == 1) {
					l++;
					transMat[k][l] = -frequency[i] * frequency[j];
					transMat[l][k] = transMat[k][l];
				}
		}
	//cholesky of transMat. cholm=upper triangle

	for (i = 1; i <= Mpas - 1; i++) {
		cholm[i][i] = transMat[i][i];
		for (k = 1; k < i; k++)
			cholm[i][i] -= cholm[k][i] * cholm[k][i];
		if (cholm[i][i] <= 0) {

			free_dmatrix(transMat, 1, Mpas - 1, 1, Mpas - 1);

			free_dmatrix(cholm, 1, Mpas - 1, 1, Mpas - 1);

			free_dmatrix(invcholm, 1, Mpas - 1, 1, Mpas - 1);

			free_dmatrix(freqPasMat, 1, Mpas - 1, 1, Mpas - 1);

			free_ivector(Followfreq, 1, M - 1);

			return (1);

			fprintf(stderr,
					"\ncholesky of the frequency matrix failed\nERROR: non-positive definite matrix!\n Might be due to missing allele numbers (alleles should be numbered from 1 to M without gaps)\n");
		}

		cholm[i][i] = sqrt(cholm[i][i]);

		for (j = i + 1; j <= Mpas - 1; j++) {
			cholm[i][j] = transMat[i][j];
			for (k = 1; k < i; k++)
				cholm[i][j] -= cholm[k][i] * cholm[k][j];
			cholm[i][j] /= cholm[i][i];

		}
	}

	//inverse of cholm

	for (i = Mpas - 1; i > 0; i--) {
		invcholm[i][i] = 1 / cholm[i][i];
		for (j = i - 1; j > 0; j--) {
			for (k = j + 1; k <= i; k++)
				invcholm[j][i] -= cholm[j][k] * invcholm[k][i];
			invcholm[j][i] /= cholm[j][j];
			invcholm[i][j] = 0;
		}
	}

	//inverse of transMat

	for (i = 1; i <= Mpas - 1; i++)
		for (j = 1; j <= Mpas - 1; j++)
			for (k = 1; k <= Mpas - 1; k++) {
				freqPasMat[i][j] += invcholm[i][k] * invcholm[j][k];

			}

	k = 0;
	for (i = 1; i <= M - 1; i++) {
		if (Followfreq[i] == 1) {
			k++;
			freqMatrix[i][i] = freqPasMat[k][k];
			l = k;
			for (j = i + 1; j <= M - 1; j++) {
				if (Followfreq[j] == 1) {
					l++;
					freqMatrix[i][j] = freqPasMat[k][l];
					freqMatrix[j][i] = freqMatrix[i][j];
				} else {
					freqMatrix[i][j] = 0;
					freqMatrix[j][i] = 0;
				}
			}
		}

		else {
			freqMatrix[i][i] = 0;
			for (j = i + 1; j <= M - 1; j++) {
				freqMatrix[i][j] = 0;
				freqMatrix[j][i] = 0;
			}
		}
	}
	/* 	printf(""); */

	/* Free the temp matrices */
	free_dmatrix(transMat, 1, Mpas - 1, 1, Mpas - 1);

	free_dmatrix(cholm, 1, Mpas - 1, 1, Mpas - 1);

	free_dmatrix(invcholm, 1, Mpas - 1, 1, Mpas - 1);

	free_dmatrix(freqPasMat, 1, Mpas - 1, 1, Mpas - 1);

	free_ivector(Followfreq, 1, M - 1);

	return 0;
}
/******************************************************
 Computes the corrected chi2 test
 *****************************************************/
void from_info2_chi2(double info_rr, double info_rf, double info_ff,
		double R1value, double *Naivefreq, double **freqNaive, double *YRvector,
		int Nall, double *chi2val) {
	int i, j;
	double chi2old = 0;
	double freqpas = 0, corrfactor = 0;

	corrfactor = 2
			/ ((info_rr - R1value * (double) info_rf / Nall
					+ R1value / Nall * R1value / Nall / 4 * info_ff));

	for (i = 1; i <= M - 1; i++)
		for (j = 1; j <= M - 1; j++)
			chi2old += (YRvector[i] / 2 - R1value * Naivefreq[i])
					* (YRvector[j] / 2 - R1value * Naivefreq[j])
					* freqNaive[i][j];

	*chi2val = chi2old * corrfactor;

}
/******************************************************
 Modify the cholaug matrix such as the M-1 first columns are equal to C-t*(Y-mu) instead of C-t*Y
 *****************************************************/
void modifcholaug(double **cholent, double **cholaug, double **chol,
		double *frequency, int size) {

	int i, j, k;

	for (i = 1; i <= size; i++)
		for (j = 1; j <= M + 3; j++) {

			if (j < M)
				cholaug[i][j] = cholent[i][j] - 2 * frequency[j];
			else
				cholaug[i][j] = cholent[i][j];
			for (k = 1; k < i; k++)
				cholaug[i][j] -= cholaug[k][j] * chol[k][i];
			cholaug[i][j] /= chol[i][i];

		}
}

/******************************************************
 Computes the information components required for the pseudo-score test for MQLS
 *****************************************************/

void comput_info_scoreMQLS(double **cholaug, double **freqMatrix,
		double *infoQL_rr, double *infoQL_rf, double *infoQL_ff,
		double *Rvector, int size) {
	int i, j;
	double info_rr = 0, info_rf = 0, info = 0, info_ff = 0;

	for (i = 1; i <= size; i++) {
		info_rr += cholaug[i][M + 3] * cholaug[i][M + 3];
		info_rf += cholaug[i][M + 3] * cholaug[i][M + 1];
		info_ff += cholaug[i][M + 1] * cholaug[i][M + 1];
		for (j = 1; j <= M - 1; j++)
			Rvector[j] += cholaug[i][M + 3] * cholaug[i][j];
	}

	*infoQL_rr += info_rr;
	*infoQL_rf += info_rf;
	*infoQL_ff += info_ff;

}
/******************************************************
 Computes the pseudo-score test
 *****************************************************/

void from_info2_score(double **freqMatrix, double infoQL_rr, double infoQL_rf,
		double infoQL_ff, double *Rvector, double *testval) {
	int i, j;
	double info = 0, score = 0;

	info = infoQL_rr - infoQL_rf * infoQL_rf / infoQL_ff;

	for (i = 1; i <= M - 1; i++)
		for (j = 1; j <= M - 1; j++)
			score += Rvector[i] * Rvector[j] / info * freqMatrix[i][j] / 2;

	*testval = score;
}
/***** GET ROBUST VARIANCE ***/

void from_info2_scoreROBUST(double **freqMatrix, double infoQL_rr,
		double infoQL_rf, double infoQL_ff, double *Rvector, double *testval,
		double ROBUST_11, double *YYvector, double *Y1vector, int Nstu,
		double *ROBUSTVAR) {
	int i, j;
	double info = 0, score = 0;

	/*       printf("For allele 1, YPHIYvector is %lf, YPHI1vector is %lf, and 1PHI1 vector is %lf,Nstu is %d \n",YYvector[1],Y1vector[1],ROBUST_11,Nstu);

	 */

	for (i = 1; i <= M - 1; i++) {
		ROBUSTVAR[i] = (1.0 / (Nstu - 1))
				* (YYvector[i] - Y1vector[i] * Y1vector[i] / ROBUST_11);

		/*
		 printf("i is %d: ROBUSTVAR is %lf and HWE var is %lf \n",i,ROBUSTVAR[i],2.0/freqMatrix[i][i]);
		 */

	}

	if (use_cov_geno_var == 0) {
		for (i = 1; i <= M - 1; i++)
			robustvar_cov[i] = ROBUSTVAR[i];
	}

	info = infoQL_rr - infoQL_rf * infoQL_rf / infoQL_ff;
	// printf("\ninfo is %f, score is %f",info,score);
	for (i = 1; i <= M - 1; i++) {
		for (j = 1; j <= M - 1; j++) {
			if (i == j) {
				score += Rvector[i] * Rvector[j] / (info * robustvar_cov[i]);
			} else {
				score += Rvector[i] * Rvector[j] / info * freqMatrix[i][j] / 2;
			}

		}
	}
	//printf("\ninfo is %f, score is %f",info,score);
	*testval = score;
}
/******************************************************
 Computes the corrected chi2 test
 *****************************************************/

void from_info2_chi2_ROBUST(double info_rr, double info_rf, double info_ff,
		double R1value, double *Naivefreq, double **freqNaive, double *YRvector,
		int Nall, double *chi2val, double ROBUST_11, double *YYvector,
		double *Y1vector, int Nstu, double *ROBUSTVAR) {
	int i, j;
	double info = 0, score = 0;
	double chi2old = 0;
	double freqpas = 0, corrfactor = 0;

	/*    printf("For allele 1, YPHIYvector is %lf, YPHI1vector is %lf, and 1PHI1 vector is %lf,Nstu is %d \n",YYvector[1],Y1vector[1],ROBUST_11,Nstu);
	 */

	for (i = 1; i <= M - 1; i++) {
		ROBUSTVAR[i] = (1.0 / (Nstu - 1))
				* (YYvector[i] - Y1vector[i] * Y1vector[i] / ROBUST_11);

		/*	printf("i is %d: ROBUSTVAR is %lf and HWE var using Naive freq is %lf \n",i,[i],2.0/freqNaive[i][i]);*/
	}

	corrfactor = 4
			/ ((info_rr - R1value * (double) info_rf / Nall
					+ R1value / Nall * R1value / Nall / 4 * info_ff));
	;

	if (use_cov_geno_var == 0) {
		for (i = 1; i <= M - 1; i++)
			robustvar_cov[i] = ROBUSTVAR[i];
	}

	for (i = 1; i <= M - 1; i++) {
		for (j = 1; j <= M - 1; j++)

		{
			if (i == j) {
				chi2old += (YRvector[i] / 2 - R1value * Naivefreq[i])
						* (YRvector[j] / 2 - R1value * Naivefreq[j])
						/ robustvar_cov[i];
			}

			else {
				chi2old += (YRvector[i] / 2 - R1value * Naivefreq[i])
						* (YRvector[j] / 2 - R1value * Naivefreq[j])
						* freqNaive[i][j] / 2;
			}

		}
	}

	*chi2val = chi2old * corrfactor;

}

/******************************************************
 Computes the information components required for the pseudo-score test
 *****************************************************/
void comput_info_score(double **cholaug, double **freqMatrix, double *infoQL_rr,
		double *infoQL_rf, double *infoQL_ff, double *Rvector, int size) {
	int i, j;
	double info_rr = 0, info_rf = 0, info = 0, info_ff = 0;

	for (i = 1; i <= size; i++) {
		info_rr += cholaug[i][M + 2] * cholaug[i][M + 2];
		info_rf += cholaug[i][M + 2] * cholaug[i][M + 1];
		info_ff += cholaug[i][M + 1] * cholaug[i][M + 1];
		for (j = 1; j <= M - 1; j++)
			Rvector[j] += cholaug[i][M + 2] * cholaug[i][j];
	}

	*infoQL_rr += info_rr;
	*infoQL_rf += info_rf;
	*infoQL_ff += info_ff;

}

void vecsrt2(double *d, int *M, char **NAME, int n) {
	int k, j, i;
	double p;
	int place;
	char tempname[100];

	for (i = 1; i < n; i++) {
		p = d[k = i];
		for (j = i + 1; j <= n; j++)
			if (d[j] < p) {
				p = d[k = j];
				place = M[k = j];
				strncpy(tempname, NAME[k = j], 100);
			}
		if (k != i) {
			d[k] = d[i];
			d[i] = p;
			M[k] = M[i];
			M[i] = place;
			strncpy(NAME[k], NAME[i], 100);
			strncpy(NAME[i], tempname, 100);
		}
	}
}

void estimate_genovar_cov() {
	int i, j, k;
	int m = 1;
	int totgc;
	int *typedGC = ivector(1, F);
	double *GGvector;
	double **GCmatrix;
	double **CCmatrix;
	double **inverCCmatrix;
	double **inverCCCGmatrix;
	double *GCinverCCCGvector;
	double **cholGC;
	double **augGC;
	double **cholaugGC;
	double **KinMatrixGC;
	double *a;
	a = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	double *b;
	b = (double *) malloc((size_t) ((Ncov * Ncov + 1) * sizeof(double)));
	GGvector = dvector(1, M);
	GCinverCCCGvector = dvector(1, M);
	GCmatrix = dmatrix(1, M, 1, Ncov);
	CCmatrix = dmatrix(1, Ncov, 1, Ncov);
	inverCCmatrix = dmatrix(1, Ncov, 1, Ncov);
	inverCCCGmatrix = dmatrix(1, Ncov, 1, M);
	for (i = 1; i <= M; i++) {
		for (j = 1; j <= Ncov; j++) {
			GCmatrix[i][j] = 0;
		}
	}
	for (i = 1; i <= Ncov; i++) {
		for (j = 1; j <= Ncov; j++) {
			CCmatrix[i][j] = 0;
		}
	}
	for (i = 1; i <= Ncov; i++) {
		for (j = 1; j <= Ncov; j++) {
			inverCCmatrix[i][j] = 0;
		}
	}
	for (i = 1; i <= Ncov; i++) {
		for (j = 1; j <= M; j++) {
			inverCCCGmatrix[i][j] = 0;
		}
	}
	for (i = 1; i <= M; i++)
		robustvar_cov[i] = 0;
	for (i = 1; i <= M; i++)
		GGvector[i] = 0;
	for (i = 1; i <= M; i++)
		GCinverCCCGvector[i] = 0;
	for (i = 1; i <= F; i++)
		typedGC[i] = 0;
	totgc = 0;
//	printf("M is %d.\n", M);

	/* for (i=1;i<=N;i++) printf("GenoVec[%d]=%f ",i,GenoVec[i]);
	 printf("\n");
	 for (i=1;i<=N;i++) printf("genoflag[%d]=%d ",i,genoflag[i]);
	 exit(1);*/
	int l, n, n1;
	readcov4(genoflagmatrix, genocovflagmatrix);
	for (i = 1; i <= F; i++) {
		typedGC[i] = 0;
		for (j = 1; j <= famdata[i].N; j++) {
			typedGC[i] += genocovflagmatrix[i][j];
		}
	}

	for (i = 1; i <= F; i++)
		totgc += typedGC[i];
	if (totgc > 0) {
		// printf("\ntotgc is %d.Ncov is %d.",totgc,Ncov);

		// for (i=1; i<=F; i++) if (typedGC[i] == 0)printf("%d %d\n",typedGC[i], i);

		int totnum1 = 0, a1, totnum2 = 0;
		for (i = 1; i <= F; i++) {

			if (typedGC[i] > 0) {
				augGC = dmatrix(1, typedGC[i], 1, (M + Ncov));
				KinMatrixGC = dmatrix(1, typedGC[i], 1, typedGC[i]);
				for (l = 1; l <= typedGC[i]; l++) {
					for (n = 1; n <= typedGC[i]; n++) {
						KinMatrixGC[l][n] = 0;
					}
				}
			}
			totnum1 = 0;

			//   if (i==1078) {printf("ALL IS WELL");exit(1);}
			for (j = 1; j <= famdata[i].N; j++) {
				//if (i==1078) printf("flag is %d.", genocovflagmatrix[1078][1]);

				if (genocovflagmatrix[i][j] == 0) {
					fscanf(famfile, "%*d %*d %*d ");
					for (k = 1; k <= (Ncov - 2); k++)
						fscanf(famfile, "%*lf");
					fscanf(famfile, "%*lf\n");
				}

				if (genocovflagmatrix[i][j] == 1) {

					totnum1++;
					KinMatrixGC[totnum1][totnum1] = Storekin[i][j][j] + 1;
					totnum2 = totnum1;
					for (k = j + 1; k <= famdata[i].N; k++) {
						if (genocovflagmatrix[i][k] == 1) {
							totnum2++;
							KinMatrixGC[totnum1][totnum2] = 2
									* Storekin[i][j][k];
							KinMatrixGC[totnum2][totnum1] = 2
									* Storekin[i][j][k];
						}
					}
					for (a1 = 1; a1 <= M; a1++)
						augGC[totnum1][a1] = 0;
					for (a1 = 1; a1 <= M; a1++) {
						if (Mark[1].mark[i][j][1] == a1)
							augGC[totnum1][a1]++;
						if (Mark[1].mark[i][j][2] == a1)
							augGC[totnum1][a1]++;
					}
					fscanf(famfile, "%*d %*d %*d ");
					augGC[totnum1][M + 1] = 1;
					for (k = 1; k <= (Ncov - 1); k++)
						fscanf(famfile, "%lf ", &augGC[totnum1][M + 1 + k]);
				}
			}
			/*         printf("\n");
			 for (l=1; l<=typedGC[i]; l++){
			 for (n=1; n<=M+Ncov; n++) {
			 printf("augGC[%d][%d]=%f ",l,n,augGC[l][n]);
			 }
			 printf("\n");
			 }
			 for (l=1; l<=typedGC[i]; l++) {
			 for (n=1; n<=typedGC[i]; n++) {
			 printf("%f ", KinMatrixGC[l][n]);
			 }
			 printf("\n");
			 }*/
			if (typedGC[i] > 0) {
				cholGC = dmatrix(1, typedGC[i], 1, typedGC[i]);
				cholaugGC = dmatrix(1, typedGC[i], 1, M + Ncov);

				if (complete_data == 0) {
				if (cholesky(KinMatrixGC, typedGC[i], augGC, M + Ncov, cholGC,
						cholaugGC, 1) != 1) {
					printf(
							"cholesky decomposition of the cholaugGC matrix failed for family %d. Might be due to inconsistent kinship coefficient values...\n",
							i);
					exit(1);
				}
				} else {
					//printf("YES WE ARE HERE!");
					for (l=1; l<=typedGC[i]; l++) {
						for (n=1; n<l; n++) {
							cholGC[l][n] = 0.0;
						}
						for (n=l; n<=typedGC[i]; n++) {
							cholGC[l][n] = global_chol[i][l][n];
						}
					}

					for (l=1; l<=typedGC[i]; l++) {
						for (n=1; n<=(M+Ncov); n++) {
							cholaugGC[l][n] = 0.0;
							for (n1=1; n1<=l; n1++) {
								cholaugGC[l][n] += global_chol1[i][l][n1] * augGC[n1][n];
							}
						}
					}

				}

				for (l = 1; l <= M; l++) {
					for (n = 1; n <= typedGC[i]; n++) {
						GGvector[l] += cholaugGC[n][l] * cholaugGC[n][l];
					}
				}
				for (l = 1; l <= M; l++) {
					for (n = 1; n <= Ncov; n++) {
						for (n1 = 1; n1 <= typedGC[i]; n1++)
							GCmatrix[l][n] += cholaugGC[n1][l]
									* cholaugGC[n1][n + M];
					}
				}
				for (l = 1; l <= Ncov; l++) {
					for (n = 1; n <= Ncov; n++) {
						for (n1 = 1; n1 <= typedGC[i]; n1++)
							CCmatrix[l][n] += cholaugGC[n1][l + M]
									* cholaugGC[n1][n + M];
					}
				}

				/*             printf("\n");
				 for (l=1;l<=M;l++){
				 for (n=1; n<=Ncov; n++) {
				 printf("%f ",GCmatrix[l][n]);
				 }
				 printf("\n");
				 }*/
				// printf("\nGGvector:\n");
				//   for (l=1;l<=M;l++) printf("%f ",GGvector[l]);
				free_dmatrix(augGC, 1, typedGC[i], 1, (M + Ncov));
				free_dmatrix(KinMatrixGC, 1, typedGC[i], 1, typedGC[i]);
				free_dmatrix(cholGC, 1, typedGC[i], 1, typedGC[i]);
				free_dmatrix(cholaugGC, 1, typedGC[i], 1, M + Ncov);
			}

		}
		rewind(famfile);
		/*     printf("\n");
		 for (l=1;l<=Ncov;l++){
		 for (n=1; n<=Ncov; n++) {
		 printf("%f ",CCmatrix[l][n]);
		 }
		 printf("\n");
		 }*/
		//     printf("\nNcov is %d.",Ncov);
		//calculate the inverse of W^tInverPhiW
		for (n = 1; n <= Ncov; n++) {
			for (l = 1; l <= Ncov; l++) {
				a[(n - 1) * Ncov + (l - 1)] = CCmatrix[l][n];
			}
		}

		for (n = 1; n <= Ncov; n++) {
			for (l = 1; l <= Ncov; l++) {
				if (l == n)
					b[(n - 1) * Ncov + (l - 1)] = 1;
				else
					b[(n - 1) * Ncov + (l - 1)] = 0;
			}
		}
		n = Ncov;
		char *uplo = "L";
		int nrhs = Ncov, lda = Ncov, ldb = Ncov, info;
		dposv_(uplo, &n, &nrhs, a, &lda, b, &ldb, &info);
		// printf("\ninfo is %d",info);
		for (n = 1; n <= Ncov; n++) {
			for (l = 1; l <= Ncov; l++) {
				inverCCmatrix[l][n] = b[(n - 1) * Ncov + (l - 1)];
			}
		}
		/*        printf("\ninfo is %d.\n",info);
		 printf("\n");
		 for (l=1;l<=Ncov;l++){
		 for (n=1; n<=Ncov; n++) {
		 printf("%f ",inverCCmatrix[l][n]);
		 }
		 printf("\n");
		 }*/
		//calculate inverCCCGmatrix
		for (l = 1; l <= Ncov; l++) {
			for (n = 1; n <= M; n++) {
				inverCCCGmatrix[l][n] = 0;
				for (n1 = 1; n1 <= Ncov; n1++)
					inverCCCGmatrix[l][n] += inverCCmatrix[l][n1]
							* GCmatrix[n][n1];
			}
		}
		/*           printf("inverCCCGmatrix:\n");
		 for (l=1;l<=Ncov;l++){
		 for (n=1; n<=M; n++) {
		 printf("%f ",inverCCCGmatrix[l][n]);
		 }
		 printf("\n");
		 }*/
		//calculate GCinverCCCGvector
		for (l = 1; l <= M; l++) {
			for (n = 1; n <= Ncov; n++) {
				GCinverCCCGvector[l] += GCmatrix[l][n] * inverCCCGmatrix[n][l];
			}
		}

		for (i = 1; i <= M; i++) {
			robustvar_cov[i] = (GGvector[i] - GCinverCCCGvector[i])
					/ (totgc - Ncov);
		}

	}
	free_dvector(GGvector, 1, M);
	free_dvector(GCinverCCCGvector, 1, M);
	free_dmatrix(GCmatrix, 1, M, 1, Ncov);
	free_dmatrix(inverCCmatrix, 1, Ncov, 1, Ncov);
	free_dmatrix(inverCCCGmatrix, 1, Ncov, 1, M);
	free_dmatrix(CCmatrix, 1, Ncov, 1, Ncov);
	free_ivector(typedGC, 1, F);
	free(a);
	free(b);

}

void handle_MZtwin(int Missing, int Option) {

	//Handle MZ twin complication for different combinations of values of Option and Missing
	int val1 = 0;
	int val2 = 0;
	int i, j, fam;
	if (Missing == 1 && Option == 1) {
		for (fam = 1; fam <= F; fam++) {
			for (i = 1; i <= famdata[fam].N; i++) {
				for (j = i + 1; j <= famdata[fam].N; j++) {
					if ((Storekin[fam][i][j] >= .5)
							&& ((Storekin[fam][i][i] < 1.
									&& Storekin[fam][j][j] < 1.)
									|| Storekin[fam][i][j] == 1.)) {
						val1 = (1.0 + Storekin[fam][i][i]) / 2;
						val2 = (1.0 + Storekin[fam][j][j]) / 2;

						if ((val1 == Storekin[fam][i][j])
								&& (val2 == Storekin[fam][i][j])
								&& (val1 == val2)) {

							famdata[fam].CorrectedAFFEC[i][2] =
									(famdata[fam].CorrectedAFFEC[i][1]
											+ famdata[fam].CorrectedAFFEC[j][1])
											/ 2;
							famdata[fam].CorrectedAFFEC[i][3] =
									famdata[fam].CorrectedAFFEC[i][1]
											+ famdata[fam].CorrectedAFFEC[j][1];
							famdata[fam].CorrectedAFFEC[j][2] = 0;
							famdata[fam].CorrectedAFFEC[j][3] = 0;
							if ((Mark[1].mark[fam][i][1] != 0
									&& Mark[1].mark[fam][i][2] != 0)
									&& (Mark[1].mark[fam][j][1] != 0
											&& Mark[1].mark[fam][j][2] != 0)) {
								Mark[1].typed[fam].N--;
								if (Mark[1].mark[fam][j][3] == 0)
									Mark[1].typed[fam].Nu--;
								if (Mark[1].mark[fam][j][3] == 1)
									Mark[1].typed[fam].Nt--;
								if (Mark[1].mark[fam][j][3] == 2)
									Mark[1].typed[fam].Nc--;
							}
							if (Mark[1].mark[fam][i][3] != 0) {
								Mark[1].mark[fam][j][3] = 0;
							}
							if (Mark[1].mark[fam][j][3] != 0) {
								Mark[1].mark[fam][i][3] = 1;
								Mark[1].mark[fam][j][3] = 0;
							}
							if (Mark[1].mark[fam][i][1] != 0
									&& Mark[1].mark[fam][i][2] != 0) {
								Mark[1].mark[fam][j][1] = 0;
								Mark[1].mark[fam][j][2] = 0;
							}
							if (Mark[1].mark[fam][j][1] != 0
									&& Mark[1].mark[fam][j][2] != 0) {
								Mark[1].mark[fam][i][1] =
										Mark[1].mark[fam][j][1];
								Mark[1].mark[fam][i][2] =
										Mark[1].mark[fam][j][2];
								Mark[1].mark[fam][j][1] = 0;
								Mark[1].mark[fam][j][2] = 0;
							}
						}

					}
				}
			}
		}
	}

	val1 = 0;
	val2 = 0;
	if (Missing == 2 && Option == 1) {
		for (fam = 1; fam <= F; fam++) {
			for (i = 1; i <= famdata[fam].N; i++) {
				if (Mark[1].mark[fam][i][1] != 0
						&& Mark[1].mark[fam][i][2] != 0) {

					for (j = i + 1; j <= famdata[fam].N; j++) {
						if (Mark[1].mark[fam][j][1] != 0
								&& Mark[1].mark[fam][j][2] != 0) {

							if ((Storekin[fam][i][j] >= .5)
									&& ((Storekin[fam][i][i] < 1.
											&& Storekin[fam][j][j] < 1.)
											|| Storekin[fam][i][j] == 1.)) {
								val1 = (1.0 + Storekin[fam][i][i]) / 2;
								val2 = (1.0 + Storekin[fam][j][j]) / 2;

								if ((val1 == Storekin[fam][i][j])
										&& (val2 == Storekin[fam][i][j])
										&& (val1 == val2)) {

									famdata[fam].CorrectedAFFEC[i][2] =
											(famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1])
													/ 2;
									famdata[fam].CorrectedAFFEC[i][3] =
											famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1];
									famdata[fam].CorrectedAFFEC[j][2] = 0;
									famdata[fam].CorrectedAFFEC[j][3] = 0;
									if ((Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0)
											&& (Mark[1].mark[fam][j][1] != 0
													&& Mark[1].mark[fam][j][2]
															!= 0)) {
										Mark[1].typed[fam].N--;
										if (Mark[1].mark[fam][j][3] == 0)
											Mark[1].typed[fam].Nu--;
										if (Mark[1].mark[fam][j][3] == 1)
											Mark[1].typed[fam].Nt--;
										if (Mark[1].mark[fam][j][3] == 2)
											Mark[1].typed[fam].Nc--;
									}
									if (Mark[1].mark[fam][i][3] != 0) {
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][j][3] != 0) {
										Mark[1].mark[fam][i][3] = 1;
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0) {
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
									if (Mark[1].mark[fam][j][1] != 0
											&& Mark[1].mark[fam][j][2] != 0) {
										Mark[1].mark[fam][i][1] =
												Mark[1].mark[fam][j][1];
										Mark[1].mark[fam][i][2] =
												Mark[1].mark[fam][j][2];
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
								}

							}
						}
					}
				}
			}
		}
	}
	val1 = 0;
	val2 = 0;
	if (Missing == 1 && Option == 2) {
		for (fam = 1; fam <= F; fam++) {
			for (i = 1; i <= famdata[fam].N; i++) {
				if (Mark[1].mark[fam][i][3] != 0) {

					for (j = i + 1; j <= famdata[fam].N; j++) {
						if (Mark[1].mark[fam][j][3] != 0) {

							if ((Storekin[fam][i][j] >= .5)
									&& ((Storekin[fam][i][i] < 1.
											&& Storekin[fam][j][j] < 1.)
											|| Storekin[fam][i][j] == 1.)) {
								val1 = (1.0 + Storekin[fam][i][i]) / 2;
								val2 = (1.0 + Storekin[fam][j][j]) / 2;

								if ((val1 == Storekin[fam][i][j])
										&& (val2 == Storekin[fam][i][j])
										&& (val1 == val2)) {

									famdata[fam].CorrectedAFFEC[i][2] =
											(famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1])
													/ 2;
									famdata[fam].CorrectedAFFEC[i][3] =
											famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1];
									famdata[fam].CorrectedAFFEC[j][2] = 0;
									famdata[fam].CorrectedAFFEC[j][3] = 0;
									if ((Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0)
											&& (Mark[1].mark[fam][j][1] != 0
													&& Mark[1].mark[fam][j][2]
															!= 0)) {
										Mark[1].typed[fam].N--;
										if (Mark[1].mark[fam][j][3] == 0)
											Mark[1].typed[fam].Nu--;
										if (Mark[1].mark[fam][j][3] == 1)
											Mark[1].typed[fam].Nt--;
										if (Mark[1].mark[fam][j][3] == 2)
											Mark[1].typed[fam].Nc--;
									}
									if (Mark[1].mark[fam][i][3] != 0) {
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][j][3] != 0) {
										Mark[1].mark[fam][i][3] = 1;
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0) {
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
									if (Mark[1].mark[fam][j][1] != 0
											&& Mark[1].mark[fam][j][2] != 0) {
										Mark[1].mark[fam][i][1] =
												Mark[1].mark[fam][j][1];
										Mark[1].mark[fam][i][2] =
												Mark[1].mark[fam][j][2];
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
								}

							}
						}
					}
				}
			}
		}
	}

	val1 = 0;
	val2 = 0;
	if (Missing == 2 && Option == 2) {

		for (fam = 1; fam <= F; fam++) {

			for (i = 1; i <= famdata[fam].N; i++) {
				if (Mark[1].mark[fam][i][1] != 0 && Mark[1].mark[fam][i][2] != 0
						&& Mark[1].mark[fam][i][3] != 0) {
					for (j = i + 1; j <= famdata[fam].N; j++) {
						if (Mark[1].mark[fam][j][1] != 0
								&& Mark[1].mark[fam][j][2] != 0
								&& Mark[1].mark[fam][j][3] != 0) {

							if ((Storekin[fam][i][j] >= .5)
									&& ((Storekin[fam][i][i] < 1.
											&& Storekin[fam][j][j] < 1.)
											|| Storekin[fam][i][j] == 1.)) {

								val1 = (1.0 + Storekin[fam][i][i]) / 2;
								val2 = (1.0 + Storekin[fam][j][j]) / 2;

								if ((val1 == Storekin[fam][i][j])
										&& (val2 == Storekin[fam][i][j])
										&& (val1 == val2)) {

									famdata[fam].CorrectedAFFEC[i][2] =
											(famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1])
													/ 2;
									famdata[fam].CorrectedAFFEC[i][3] =
											famdata[fam].CorrectedAFFEC[i][1]
													+ famdata[fam].CorrectedAFFEC[j][1];
									famdata[fam].CorrectedAFFEC[j][2] = 0;
									famdata[fam].CorrectedAFFEC[j][3] = 0;
									if ((Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0)
											&& (Mark[1].mark[fam][j][1] != 0
													&& Mark[1].mark[fam][j][2]
															!= 0)) {
										Mark[1].typed[fam].N--;
										if (Mark[1].mark[fam][j][3] == 0)
											Mark[1].typed[fam].Nu--;
										if (Mark[1].mark[fam][j][3] == 1)
											Mark[1].typed[fam].Nt--;
										if (Mark[1].mark[fam][j][3] == 2)
											Mark[1].typed[fam].Nc--;
									}
									if (Mark[1].mark[fam][i][3] != 0) {
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][j][3] != 0) {
										Mark[1].mark[fam][i][3] = 1;
										Mark[1].mark[fam][j][3] = 0;
									}
									if (Mark[1].mark[fam][i][1] != 0
											&& Mark[1].mark[fam][i][2] != 0) {
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
									if (Mark[1].mark[fam][j][1] != 0
											&& Mark[1].mark[fam][j][2] != 0) {
										Mark[1].mark[fam][i][1] =
												Mark[1].mark[fam][j][1];
										Mark[1].mark[fam][i][2] =
												Mark[1].mark[fam][j][2];
										Mark[1].mark[fam][j][1] = 0;
										Mark[1].mark[fam][j][2] = 0;
									}
								}

							}
						}
					}
				}

			}

		}

	}
}
